package com.biz.crm.cps.business.reward.local.service.strategy;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.biz.crm.cps.business.reward.sdk.dto.CashRandomDto;
import com.biz.crm.cps.business.reward.sdk.dto.RewardConditionDto;
import com.biz.crm.cps.business.reward.sdk.service.RandomQuotaComputeService;
import com.biz.crm.cps.business.reward.sdk.service.observer.ComputeTypeMountRegister;
import com.biz.crm.cps.business.reward.sdk.service.strategy.RewardComputeStrategy;
import com.biz.crm.cps.business.reward.sdk.vo.CashRandomVo;
import com.biz.crm.cps.business.reward.sdk.vo.ComputeCashVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

/**
 * @author hecheng
 * @description: 定额随机计算
 * @date 2021/8/16 下午4:10
 */
@Component("RandomAmountComputeStrategyImpl")
public class RandomAmountComputeStrategyImpl implements RewardComputeStrategy {

  @Autowired
  @Qualifier("RandomAmountComputeTypeMountRegisterServiceImpl")
  private ComputeTypeMountRegister computeTypeMountRegister;
  @Autowired
  private RandomQuotaComputeService randomQuotaComputeService;
  @Autowired
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public String getKey() {
    return this.computeTypeMountRegister.getKey();
  }

  @Override
  public ComputeCashVo calculate(RewardConditionDto dto) {
    Validate.notNull(dto.getRewardData(), "奖励计算条件不能为空!");
    Validate.notBlank(dto.getRewardData(), "奖励值不能为空!");
    ComputeCashVo computeCashVo = new ComputeCashVo();
    computeCashVo.setRecordType(dto.getAwardConditionFlag());
    List<CashRandomVo> changeCashList = Lists.newArrayList();
    try {
      changeCashList = JSONArray.parseArray(dto.getRewardData(), CashRandomVo.class);
    } catch (JSONException e) {
      throw new IllegalArgumentException("奖励值配置格式不正确");
    }
    List<CashRandomDto> params = (List<CashRandomDto>) this.nebulaToolkitService.copyCollectionByWhiteList(changeCashList, CashRandomVo.class, CashRandomDto.class, HashSet.class, ArrayList.class);
    // 计算金额
    Validate.notNull(this.randomQuotaComputeService, "定额随机算法不能为空！");
    BigDecimal amount = this.randomQuotaComputeService.execute(params);
    computeCashVo.setRecordCash(amount);
    return computeCashVo;
  }

}
