/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.reward.local.service.observer;

import com.biz.crm.cps.business.activity.sdk.dto.ActivityRewardConditionDto;
import com.biz.crm.cps.business.activity.sdk.observer.ActivityRewardServiceObserver;
import com.biz.crm.cps.business.consumer.sdk.service.ConsumerVoService;
import com.biz.crm.cps.business.consumer.sdk.vo.ConsumerVo;
import com.biz.crm.cps.business.participator.sdk.common.enums.ParticipatorTypeEnum;
import com.biz.crm.cps.business.participator.sdk.service.ParticipatorVoService;
import com.biz.crm.cps.business.participator.sdk.vo.ParticipatorVo;
import com.biz.crm.cps.business.reward.sdk.dto.RewardConditionDto;
import com.biz.crm.cps.business.reward.sdk.service.observer.RewardServiceObserver;
import com.biz.crm.cps.external.barcode.sdk.service.ScanCodeVoService;
import com.biz.crm.cps.external.barcode.sdk.vo.ScanCodeVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="ActivityRewardBridgeServiceObserverImpl")
public class ActivityRewardBridgeServiceObserverImpl
implements ActivityRewardServiceObserver {
    private static final Logger log = LoggerFactory.getLogger(ActivityRewardBridgeServiceObserverImpl.class);
    @Autowired(required=false)
    private List<RewardServiceObserver> awardServiceObservers;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private ParticipatorVoService participatorVoService;
    @Autowired(required=false)
    private ConsumerVoService consumerVoService;
    @Autowired(required=false)
    private ScanCodeVoService scanCodeVoService;

    public void createRewardRecord(List<ActivityRewardConditionDto> dtos) {
        log.debug("createRewardRecord\u83b7\u53d6\u5165\u53c2={}", dtos);
        if (CollectionUtils.isEmpty(dtos)) {
            return;
        }
        List<RewardConditionDto> rewardConditionDtos = this.rewardArgumentTransform(dtos);
        this.notify(rewardConditionDtos);
    }

    private void notify(List<RewardConditionDto> rewardConditionDtos) {
        if (CollectionUtils.isEmpty(rewardConditionDtos)) {
            return;
        }
        for (RewardConditionDto item : rewardConditionDtos) {
            if (CollectionUtils.isEmpty(this.awardServiceObservers)) continue;
            for (RewardServiceObserver rewardServiceObserver : this.awardServiceObservers) {
                if (StringUtils.isNotBlank((String)item.getAdditionalParticipatorCode())) {
                    rewardServiceObserver.onCreate(item);
                    continue;
                }
                log.info("{}\u626b\u7801\u672a\u627e\u5230\u6240\u5c5e\u83b7\u5229\u8005{}\u8df3\u8fc7\u672c\u6b21\u8fd4\u5229", (Object)item.getActualParticipatorName(), (Object)item.getAdditionalParticipatorFlag());
            }
            this.notify(item.getRewardConditionDtos());
        }
    }

    private List<RewardConditionDto> rewardArgumentTransform(List<ActivityRewardConditionDto> dtos) {
        ArrayList list = Lists.newArrayList();
        for (ActivityRewardConditionDto item : dtos) {
            RewardConditionDto rewardConditionDto = (RewardConditionDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, RewardConditionDto.class, HashSet.class, ArrayList.class, new String[0]);
            rewardConditionDto = this.buildParticipatorInfo(rewardConditionDto, item);
            if (!CollectionUtils.isEmpty((Collection)item.getActivityRewardConditionDtos())) {
                List<RewardConditionDto> child = this.rewardArgumentTransform(item.getActivityRewardConditionDtos());
                rewardConditionDto.setRewardConditionDtos(child);
            }
            list.add(rewardConditionDto);
        }
        return list;
    }

    private RewardConditionDto buildParticipatorInfo(RewardConditionDto target, ActivityRewardConditionDto source) {
        Validate.notBlank((CharSequence)source.getParticipatorFlag(), (String)"\u5f97\u5230\u8fd9\u4efd\u5956\u52b1\u7684\u53c2\u4e0e\u8005Flag\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        List participatorVos = null;
        if (Objects.equals(ParticipatorTypeEnum.CONSUMER.getDictCode(), source.getActualParticipatorFlag())) {
            ParticipatorTypeEnum participatorTypeEnum;
            List belong;
            ScanCodeVo scanCodeVo;
            String openId = target.getActualParticipatorCode();
            ConsumerVo consumerVo = this.consumerVoService.findByExternalId(openId);
            Validate.notNull((Object)consumerVo, (String)"%s\u5206\u5229\u65f6\uff0c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[]{source.getParticipatorName()});
            participatorVos = Lists.newArrayList();
            ParticipatorVo actualScan = new ParticipatorVo();
            actualScan.setParticipatorName(consumerVo.getNickname());
            actualScan.setParticipatorCode(consumerVo.getConsumerCode());
            actualScan.setParticipatorType(target.getActualParticipatorFlag());
            participatorVos.add(actualScan);
            if (!Objects.equals(ParticipatorTypeEnum.CONSUMER.getDictCode(), source.getParticipatorFlag()) && StringUtils.isNotBlank((String)source.getRecordCode()) && (scanCodeVo = this.scanCodeVoService.findByRecordCode(source.getRecordCode())) != null && !CollectionUtils.isEmpty((Collection)(belong = this.participatorVoService.findByParticipatorTypeAndParticipatorCode((participatorTypeEnum = ParticipatorTypeEnum.getByKey((String)scanCodeVo.getParticipatorType())).getDictCode(), scanCodeVo.getParticipatorCode())))) {
                participatorVos.addAll(belong);
            }
        } else {
            participatorVos = this.participatorVoService.findByParticipatorTypeAndParticipatorCode(target.getActualParticipatorFlag(), target.getActualParticipatorCode());
        }
        Validate.notEmpty((Collection)participatorVos, (String)"\u5206\u5229\u53c2\u4e0e\u8005\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        ParticipatorVo participatorVo = participatorVos.stream().filter(item -> Objects.equals(item.getParticipatorType(), source.getParticipatorFlag())).findFirst().orElse(null);
        ParticipatorVo actualParticipatorVo = participatorVos.stream().filter(item -> Objects.equals(item.getParticipatorType(), source.getActualParticipatorFlag())).findFirst().orElse(null);
        Validate.notNull((Object)actualParticipatorVo, (String)"%\u5b9e\u9645\u626b\u7801\u8005\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[]{source.getActualParticipatorCode()});
        target.setActualParticipatorName(actualParticipatorVo.getParticipatorName());
        if (participatorVo != null) {
            target.setOrgCode(participatorVo.getOrgCode());
            target.setOrgName(participatorVo.getOrgName());
            target.setPhone(participatorVo.getPhone());
            target.setAdditionalParticipatorCode(participatorVo.getParticipatorCode());
            target.setAdditionalParticipatorName(participatorVo.getParticipatorName());
            target.setAdditionalParticipatorFlag(participatorVo.getParticipatorType());
            target.setChannel(participatorVo.getChannel());
        }
        return target;
    }
}

