/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.reward.local.service.observer;

import cn.hutool.json.JSONUtil;
import com.biz.crm.cps.business.activity.scan.sdk.service.observer.ScanActivityRewardObserver;
import com.biz.crm.cps.business.activity.scan.sdk.vo.RewardValueVo;
import com.biz.crm.cps.business.activity.scan.sdk.vo.ScanActivityRewardObserverVo;
import com.biz.crm.cps.business.participator.sdk.common.enums.ParticipatorTypeEnum;
import com.biz.crm.cps.business.reward.sdk.dto.RewardConditionDto;
import com.biz.crm.cps.business.reward.sdk.service.observer.RewardServiceObserver;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ScanActivityRewardObserverImpl
implements ScanActivityRewardObserver {
    private static final Logger log = LoggerFactory.getLogger(ScanActivityRewardObserverImpl.class);
    @Autowired(required=false)
    private List<RewardServiceObserver> awardServiceObservers;
    private static final String SCAN_ACTIVITY_FORWARD = "scan_activity_forward";
    private static final String SCAN_ACTIVITY_FORWARD_DESC = "\u626b\u7801\u6d3b\u52a8\u5206\u5229";
    private static final String SCAN_ACTIVITY_REVERSE = "scan_activity_reverse";
    private static final String SCAN_ACTIVITY_REVERSE_DESC = "\u626b\u7801\u6d3b\u52a8\u8fd4\u5229";
    private static final String FIXED_AMOUNT = "fixedAmount";
    private static final String RANDOM_AMOUNT = "randomAmount";

    public void createRewardRecord(List<ScanActivityRewardObserverVo> data) {
        log.debug("******createRewardRecord\u83b7\u53d6\u5165\u53c2={}", data);
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        List<RewardConditionDto> dtoList = this.rewardArgumentTransform(data, SCAN_ACTIVITY_FORWARD_DESC);
        this.notify(dtoList);
    }

    private List<RewardConditionDto> rewardArgumentTransform(List<ScanActivityRewardObserverVo> data, String rebateType) {
        if (CollectionUtils.isEmpty(data)) {
            return Lists.newLinkedList();
        }
        ArrayList list = Lists.newArrayList();
        for (ScanActivityRewardObserverVo item : data) {
            RewardConditionDto cur = new RewardConditionDto();
            cur.setRewardMethodFlag(item.getRewardType());
            cur.setAwardConditionFlag(item.getRandomFlag() != false ? RANDOM_AMOUNT : FIXED_AMOUNT);
            cur.setAdditionalParticipatorCode(item.getUserCode());
            cur.setAdditionalParticipatorName(item.getName());
            cur.setChannel(item.getChannel());
            cur.setOrgCode(item.getOrgCode());
            cur.setOrgName(item.getOrgName());
            ParticipatorTypeEnum type = ParticipatorTypeEnum.getByKey((String)item.getParticipateObj());
            Validate.notNull((Object)type, (String)"\u53c2\u4e0e\u7c7b\u578b\u5f02\u5e38");
            cur.setAdditionalParticipatorFlag(type.getDictCode());
            cur.setTriggerAction(item.getTriggerAction());
            cur.setTriggerObject(item.getMaterialCode());
            cur.setRecordCode(item.getRecordCode());
            cur.setRebateType(rebateType);
            cur.setActCode(item.getScanActCode());
            cur.setAccountCode(item.getAccountCode());
            cur.setRewardData(this.findRewardData(item));
            list.add(cur);
            if (CollectionUtils.isEmpty((Collection)item.getItemList())) continue;
            list.addAll(this.rewardArgumentTransform(item.getItemList(), SCAN_ACTIVITY_REVERSE_DESC));
        }
        return list;
    }

    private String findRewardData(ScanActivityRewardObserverVo item) {
        RewardValueVo vo;
        if (Objects.isNull(item) || Objects.isNull(item.getRandomFlag()) || CollectionUtils.isEmpty((Collection)item.getValueList())) {
            return "";
        }
        if (Boolean.TRUE.equals(item.getRandomFlag())) {
            return JSONUtil.toJsonStr((Object)item.getValueList());
        }
        if (Boolean.FALSE.equals(item.getRandomFlag()) && (Objects.nonNull(vo = (RewardValueVo)item.getValueList().stream().findFirst().orElse(null)) || Objects.nonNull(vo.getCash()))) {
            return String.valueOf(vo.getCash());
        }
        return "";
    }

    private void notify(List<RewardConditionDto> dtoList) {
        if (CollectionUtils.isEmpty(dtoList)) {
            return;
        }
        for (RewardConditionDto item : dtoList) {
            if (CollectionUtils.isEmpty(this.awardServiceObservers)) continue;
            for (RewardServiceObserver rewardServiceObserver : this.awardServiceObservers) {
                if (StringUtils.isNotBlank((String)item.getAdditionalParticipatorCode())) {
                    rewardServiceObserver.onCreate(item);
                    continue;
                }
                log.info("{}\u626b\u7801\u672a\u627e\u5230\u6240\u5c5e\u83b7\u5229\u8005{}\u8df3\u8fc7\u672c\u6b21\u8fd4\u5229", (Object)item.getActualParticipatorName(), (Object)item.getAdditionalParticipatorFlag());
            }
            this.notify(item.getRewardConditionDtos());
        }
    }
}

