/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.reward.local.service.strategy;

import com.biz.crm.cps.business.reward.sdk.dto.RewardConditionDto;
import com.biz.crm.cps.business.reward.sdk.service.observer.ComputeTypeMountRegister;
import com.biz.crm.cps.business.reward.sdk.service.strategy.RewardComputeStrategy;
import com.biz.crm.cps.business.reward.sdk.vo.ComputeCashVo;
import java.math.BigDecimal;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="FixedAmountComputeStrategyImpl")
public class FixedAmountComputeStrategyImpl
implements RewardComputeStrategy {
    @Autowired
    @Qualifier(value="FixedAmountComputeTypeMountRegisterServiceImpl")
    private ComputeTypeMountRegister computeTypeMountRegister;

    public String getKey() {
        return this.computeTypeMountRegister.getKey();
    }

    public ComputeCashVo calculate(RewardConditionDto dto) {
        Validate.notNull((Object)dto.getRewardData(), (String)"\u5956\u52b1\u8ba1\u7b97\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getRewardData(), (String)"\u5956\u52b1\u503c\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        ComputeCashVo computeCashVo = new ComputeCashVo();
        computeCashVo.setRecordType(dto.getAwardConditionFlag());
        BigDecimal recordCash = new BigDecimal(dto.getRewardData()).setScale(4, 0);
        computeCashVo.setRecordCash(recordCash);
        return computeCashVo;
    }
}

