/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.reward.local.service.strategy;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.biz.crm.cps.business.reward.sdk.dto.CashRandomDto;
import com.biz.crm.cps.business.reward.sdk.dto.RewardConditionDto;
import com.biz.crm.cps.business.reward.sdk.service.RandomQuotaComputeService;
import com.biz.crm.cps.business.reward.sdk.service.observer.ComputeTypeMountRegister;
import com.biz.crm.cps.business.reward.sdk.service.strategy.RewardComputeStrategy;
import com.biz.crm.cps.business.reward.sdk.vo.CashRandomVo;
import com.biz.crm.cps.business.reward.sdk.vo.ComputeCashVo;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="RandomAmountComputeStrategyImpl")
public class RandomAmountComputeStrategyImpl
implements RewardComputeStrategy {
    @Autowired
    @Qualifier(value="RandomAmountComputeTypeMountRegisterServiceImpl")
    private ComputeTypeMountRegister computeTypeMountRegister;
    @Autowired
    private RandomQuotaComputeService randomQuotaComputeService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    public String getKey() {
        return this.computeTypeMountRegister.getKey();
    }

    public ComputeCashVo calculate(RewardConditionDto dto) {
        Validate.notNull((Object)dto.getRewardData(), (String)"\u5956\u52b1\u8ba1\u7b97\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getRewardData(), (String)"\u5956\u52b1\u503c\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        ComputeCashVo computeCashVo = new ComputeCashVo();
        computeCashVo.setRecordType(dto.getAwardConditionFlag());
        List changeCashList = Lists.newArrayList();
        try {
            changeCashList = JSONArray.parseArray((String)dto.getRewardData(), CashRandomVo.class);
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("\u5956\u52b1\u503c\u914d\u7f6e\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        List params = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)changeCashList, CashRandomVo.class, CashRandomDto.class, HashSet.class, ArrayList.class, new String[0]);
        Validate.notNull((Object)this.randomQuotaComputeService, (String)"\u5b9a\u989d\u968f\u673a\u7b97\u6cd5\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        BigDecimal amount = this.randomQuotaComputeService.execute(params);
        computeCashVo.setRecordCash(amount);
        return computeCashVo;
    }
}

