/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.reward.redpacket.local.service.internal;

import com.biz.crm.cps.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.common.sdk.vo.LoginUserDetails;
import com.biz.crm.cps.business.consumer.sdk.service.ConsumerVoService;
import com.biz.crm.cps.business.consumer.sdk.vo.ConsumerVo;
import com.biz.crm.cps.business.participator.sdk.common.enums.ParticipatorTypeEnum;
import com.biz.crm.cps.business.reward.redpacket.local.entity.RedPacketDetailEntity;
import com.biz.crm.cps.business.reward.redpacket.local.service.RedPacketDetailService;
import com.biz.crm.cps.business.reward.redpacket.sdk.dto.RedPacketDetailDto;
import com.biz.crm.cps.business.reward.redpacket.sdk.service.RedPacketRewardCashProcessVoService;
import com.biz.crm.cps.business.reward.sdk.common.enums.CashActionEnum;
import com.biz.crm.cps.business.reward.sdk.common.enums.IncomeStatusEnum;
import com.biz.crm.cps.business.reward.sdk.dto.RewardCashConditionDto;
import com.biz.crm.cps.business.reward.sdk.service.RewardCashVoService;
import com.biz.crm.cps.business.reward.sdk.service.observer.RewardCashObserver;
import com.biz.crm.cps.business.reward.sdk.service.observer.RewardMountRegister;
import com.biz.crm.cps.business.reward.sdk.service.observer.RewardTypeStatisticsServiceObserver;
import com.biz.crm.cps.business.reward.sdk.vo.RewardCashRecordVo;
import com.biz.crm.cps.business.reward.sdk.vo.RewardTypeStatisticsVo;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="RedPacketRewardCashVoServiceImpl")
public class RedPacketRewardCashVoServiceImpl
implements RewardCashVoService {
    @Autowired(required=false)
    private List<RewardCashObserver> rewardCashObserverList;
    @Autowired
    private RedPacketRewardCashProcessVoService redPacketRewardCashProcessVoService;
    @Autowired
    private RedPacketDetailService redPacketDetailService;
    @Autowired
    @Qualifier(value="RedpacketRewardMountRegisterServiceImpl")
    private RewardMountRegister rewardMountRegister;
    @Autowired
    @Qualifier(value="RedPacketRewardTypeStatisticsServiceObserverImpl")
    private RewardTypeStatisticsServiceObserver rewardTypeStatisticsServiceObserver;
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private ConsumerVoService consumerVoService;

    @Transactional
    public void cash(RewardCashConditionDto conditionDto) {
        Validate.notNull((Object)conditionDto, (String)"\u5151\u4ed8\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)conditionDto.getAmount(), (String)"\u63d0\u73b0\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)conditionDto.getParticipatorFlag(), (String)"\u53c2\u4e0e\u8005\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)conditionDto.getParticipatorCode(), (String)"\u53c2\u4e0e\u8005\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty(this.rewardCashObserverList, (String)"\u5151\u73b0\u6a21\u5757\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Validate.isTrue((conditionDto.getAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u63d0\u73b0\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0", (Object[])new Object[0]);
        this.redPacketRewardCashProcessVoService.buildCashType(conditionDto);
        this.redPacketRewardCashProcessVoService.validate(conditionDto);
        RedPacketDetailDto redPacketDetailDto = new RedPacketDetailDto();
        redPacketDetailDto.setAmount(conditionDto.getAmount());
        redPacketDetailDto.setParticipatorCode(conditionDto.getParticipatorCode());
        redPacketDetailDto.setParticipatorType(conditionDto.getParticipatorFlag());
        redPacketDetailDto.setParticipatorName(conditionDto.getParticipatorName());
        redPacketDetailDto.setTriggerAction(CashActionEnum.WITHDRAW.getKey());
        redPacketDetailDto.setTriggerObject("");
        redPacketDetailDto.setType(IncomeStatusEnum.SUBTRACT.getDictCode());
        RedPacketDetailEntity redPacketDetail = this.redPacketDetailService.create(redPacketDetailDto);
        conditionDto.setRewardId(redPacketDetail.getId());
        conditionDto.setRewardKey(this.rewardMountRegister.getKey());
        conditionDto.setRewardName(this.rewardMountRegister.getName());
        for (RewardCashObserver rewardCashObserver : this.rewardCashObserverList) {
            RewardCashRecordVo rewardCashRecordVo = rewardCashObserver.onCash(conditionDto);
            if (rewardCashRecordVo == null) continue;
            redPacketDetail.setTriggerObject(rewardCashRecordVo.getCashCode());
            this.redPacketDetailService.update(redPacketDetail);
            return;
        }
    }

    @Transactional
    public void currentUserCash(BigDecimal amount) {
        Validate.notNull((Object)amount, (String)"\u63d0\u73b0\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        LoginUserDetails userDetails = this.loginUserService.getLoginUser();
        ParticipatorTypeEnum participatorTypeEnum = ParticipatorTypeEnum.getByKey((String)userDetails.getUsertype());
        RewardCashConditionDto conditionDto = new RewardCashConditionDto();
        conditionDto.setParticipatorCode(userDetails.getConsumerCode());
        conditionDto.setParticipatorName(userDetails.getConsumerName());
        conditionDto.setParticipatorFlag(participatorTypeEnum.getDictCode());
        conditionDto.setPayeeCode(userDetails.getAccount());
        conditionDto.setPayeeName(userDetails.getRealName());
        conditionDto.setPayeePhone(userDetails.getPhone());
        conditionDto.setAmount(amount);
        conditionDto.setOpenId(userDetails.getOpenId());
        this.cash(conditionDto);
    }

    @Transactional
    public void consumerCash(BigDecimal amount, String openId) {
        Validate.notNull((Object)amount, (String)"\u63d0\u73b0\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)openId, (String)"\u6d88\u8d39\u8005\u63d0\u73b0\u65f6openid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ConsumerVo consumerVo = this.consumerVoService.findByExternalId(openId);
        Validate.notNull((Object)consumerVo, (String)"\u6d88\u8d39\u8005\u63d0\u73b0\u65f6openid\u672a\u67e5\u8be2\u5230\u6d88\u8d39\u8005\u4fe1\u606f", (Object[])new Object[0]);
        RewardCashConditionDto conditionDto = new RewardCashConditionDto();
        conditionDto.setParticipatorCode(consumerVo.getConsumerCode());
        conditionDto.setParticipatorName(consumerVo.getNickname());
        conditionDto.setParticipatorFlag(ParticipatorTypeEnum.CONSUMER.getDictCode());
        conditionDto.setPayeeCode(consumerVo.getExternalId());
        conditionDto.setPayeeName(consumerVo.getNickname());
        conditionDto.setPayeePhone(consumerVo.getPhone());
        conditionDto.setAmount(amount);
        conditionDto.setOpenId(consumerVo.getExternalId());
        this.cash(conditionDto);
    }

    public BigDecimal findByConsumerOpenIdRecordCodes(String openId, List<String> recordCodes) {
        ConsumerVo consumerVo = this.consumerVoService.findByExternalId(openId);
        if (Objects.isNull(consumerVo)) {
            return null;
        }
        RewardTypeStatisticsVo statisticsVo = this.rewardTypeStatisticsServiceObserver.onRequestRewardTypeStatisticsVo(consumerVo.getConsumerCode(), recordCodes);
        if (Objects.isNull(statisticsVo)) {
            return null;
        }
        return statisticsVo.getAmount();
    }
}

