/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.reward.redpacket.local.service.observer;

import com.biz.crm.cps.business.reward.redpacket.sdk.service.RedPacketTriggerObjectStatisticsVoService;
import com.biz.crm.cps.business.reward.sdk.service.observer.RewardMountRegister;
import com.biz.crm.cps.business.reward.sdk.service.observer.RewardRelTriggerObjectServiceObserver;
import com.biz.crm.cps.business.reward.sdk.vo.RewardRelTriggerObjectItemVo;
import com.biz.crm.cps.business.reward.sdk.vo.RewardTypeStatisticsVo;
import com.biz.crm.cps.business.reward.sdk.vo.TriggerObjectRewardStatisticsVo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="RewardRelTriggerObjectServiceObserverImpl")
public class RewardRelTriggerObjectServiceObserverImpl
implements RewardRelTriggerObjectServiceObserver {
    @Autowired
    @Qualifier(value="RedpacketRewardMountRegisterServiceImpl")
    private RewardMountRegister rewardMountRegister;
    @Autowired
    private RedPacketTriggerObjectStatisticsVoService triggerObjectStatisticsVoService;

    public List<RewardRelTriggerObjectItemVo> onRequestRewardRelTriggerObjectItems(String triggerAction, List<String> triggerObjects) {
        if (StringUtils.isBlank((CharSequence)triggerAction) || CollectionUtils.isEmpty(triggerObjects)) {
            return null;
        }
        List result = this.triggerObjectStatisticsVoService.findByTriggerActionAndTriggerObjects(triggerAction, triggerObjects);
        if (CollectionUtils.isEmpty((Collection)result)) {
            result = Lists.newArrayList();
        }
        ArrayList list = Lists.newArrayList();
        for (String triggerObject : triggerObjects) {
            RewardTypeStatisticsVo vo = new RewardTypeStatisticsVo();
            TriggerObjectRewardStatisticsVo statisticsVo = result.stream().filter(item -> Objects.equals(triggerObject, item.getTriggerObject())).findFirst().orElse(null);
            vo.setName(this.rewardMountRegister.getName());
            vo.setFlag(this.rewardMountRegister.getFlag());
            vo.setKey(this.rewardMountRegister.getKey());
            vo.setAmount(statisticsVo == null ? BigDecimal.ZERO : statisticsVo.getAmount());
            RewardRelTriggerObjectItemVo item2 = new RewardRelTriggerObjectItemVo();
            item2.setTriggerObject(triggerObject);
            item2.setRewardStatisticsVo(vo);
            list.add(item2);
        }
        return list;
    }
}

