package com.biz.crm.cps.business.reward.redpacket.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.business.reward.redpacket.local.entity.KeepBooksDetailEntity;
import com.biz.crm.cps.business.reward.redpacket.local.service.KeepBooksDetailService;
import com.biz.crm.cps.business.reward.redpacket.sdk.dto.KeepBooksDetailDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @ClassName: KeepBooksController
 * @Author: yangfan
 * @Description: 上账记录controller
 * @Date: 2021/8/7 15:37
 * @Version: 1.0
 */

@Api(tags = "上账记录")
@Slf4j
@RestController
@RequestMapping("/v1/redPacket/keepBooks")
public class KeepBooksDetailController {

  @Autowired
  private KeepBooksDetailService keepBooksDetailService;

  /**
   * 上账记录多条件分页查询
   *
   * @return
   */
  @ApiOperation(value = "上账记录多条件分页查询", notes = "分页参数为page和size，page从0开始，size默认50;")
  @GetMapping("findByConditions")
  public Result<Page<KeepBooksDetailEntity>> findByConditions(@PageableDefault(50) Pageable pageable, KeepBooksDetailDto dto) {
    try {
      Page<KeepBooksDetailEntity> result = this.keepBooksDetailService.findByConditions(pageable, dto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 创建
   *
   * @param dto
   * @return
   */
  @ApiOperation(value = "创建", notes = "创建")
  @PostMapping("")
  public Result<KeepBooksDetailEntity> create(@RequestBody @ApiParam(name = "KeepBooksDetailDto") KeepBooksDetailDto dto) {
    try {
      KeepBooksDetailEntity result = this.keepBooksDetailService.create(dto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
