package com.biz.crm.cps.business.reward.redpacket.local.controller;

import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.business.reward.redpacket.sdk.service.RedPacketBalanceVoService;
import com.biz.crm.cps.business.reward.redpacket.sdk.vo.RedPacketBalanceVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Author: zengxingwang
 * @Date: 2021/8/7 14:20
 */
@Api(tags = "红包统计")
@Slf4j
@RestController
@RequestMapping("/v1/redPacket/balance")
public class RedPacketBalanceVoController {

  @Autowired
  private RedPacketBalanceVoService redPacketBalanceVoService;

  /**
   * 红包余额看板
   */
  @ApiOperation(value = "红包余额看板")
  @GetMapping(value="findByStatisticsDay")
  public Result<RedPacketBalanceVo> findByStatisticsDay(@RequestParam @ApiParam(name="statisticsDay" , value="统计天数") Integer statisticsDay) {
    try {
      RedPacketBalanceVo vo = redPacketBalanceVoService.findByStatisticsDay(statisticsDay);
      return Result.ok(vo);
    } catch(RuntimeException e) {
      log.error(e.getMessage() , e);
      return Result.error(e.getMessage());
    }
  }



}
