package com.biz.crm.cps.business.reward.redpacket.local.controller;

import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.business.reward.redpacket.local.entity.RedPacketConfigEntity;
import com.biz.crm.cps.business.reward.redpacket.local.service.RedPacketConfigService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 红包权益配置Controller
 * @Author: zengxingwang
 * @Date: 2021/10/11 15:24
 */
@Api(tags = "红包权益配置Controller")
@Slf4j
@RestController
@RequestMapping("/v1/redPacket/config")
public class RedPacketConfigController {

  @Autowired
  private RedPacketConfigService redPacketConfigService;

  /**
   * 创建红包权益配置
   * @param configs
   */
  @ApiOperation(value = "创建红包权益配置")
  @PostMapping(value = "")
  public Result<?> create(@RequestBody @ApiParam(name = "configEntity", value = "红包权益配置") List<RedPacketConfigEntity> configs) {
    try {
      this.redPacketConfigService.create(configs);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 查询所有配置
   * @return
   */
  @ApiOperation(value = "查询所有配置")
  @GetMapping(value = "findAll")
  public Result<List<RedPacketConfigEntity>> findAll() {
    try {
      List<RedPacketConfigEntity> list = this.redPacketConfigService.findAll();
      return Result.ok(list);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
