package com.biz.crm.cps.business.reward.redpacket.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.LoginUserDetailsForCPS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.business.reward.redpacket.local.entity.RedPacketEntity;
import com.biz.crm.cps.business.reward.redpacket.local.service.RedPacketService;
import com.biz.crm.cps.business.reward.redpacket.sdk.dto.CustomerRedPacketBalanceDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Objects;

/**
 * @Author: zengxingwang
 * @Date: 2021/8/7 14:20
 */
@Api(tags = "客户红包")
@Slf4j
@RestController
@RequestMapping("/v1/redPacket/custom")
public class RedPacketController {

  @Autowired
  private RedPacketService redPacketService;
  @Autowired(required = false)
  private LoginUserService loginUserService;

  /**
   * 条件查询分客户红包列表
   */
  @ApiOperation(value = "条件查询分客户红包列表")
  @GetMapping(value = "findByConditions")
  public Result<Page<RedPacketEntity>> findByConditions(@ApiParam(name = "balanceDto", value = "客户余额dto") CustomerRedPacketBalanceDto balanceDto,
          @PageableDefault(50) Pageable pageable) {
    try {
      Page<RedPacketEntity> page = redPacketService.findByConditions(balanceDto, pageable);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 终端/经销商 红包余额
   */
  @ApiOperation(value = "终端/经销商 红包余额")
  @GetMapping(value = "findByCurrentUser")
  public Result<RedPacketEntity> findByCurrentUser() {
    try {
      LoginUserDetailsForCPS userDetails = this.loginUserService.getLoginDetails(LoginUserDetailsForCPS.class);
      RedPacketEntity redPacket = this.redPacketService.findByParticipatorCode(userDetails.getConsumerCode());
      if (Objects.nonNull(redPacket)) {
        BigDecimal balance = redPacket.getBalance() == null ? BigDecimal.ZERO : redPacket.getBalance();
        redPacket.setBalance(balance.setScale(2, RoundingMode.HALF_UP));
      }
      return Result.ok(redPacket);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
