package com.biz.crm.cps.business.reward.redpacket.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.business.reward.redpacket.local.entity.RedPacketDetailEntity;
import com.biz.crm.cps.business.reward.redpacket.local.service.RedPacketDetailService;
import com.biz.crm.cps.business.reward.redpacket.sdk.dto.RedPacketDetailDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @ClassName: RedPacketDetailController
 * @Author: yangfan
 * @Description: 红包流水controller
 * @Date: 2021/8/7 15:07
 * @Version: 1.0
 */

@Api(tags = "红包流水信息")
@Slf4j
@RestController
@RequestMapping("/v1/redPacket/award")
public class RedPacketDetailController {

  @Autowired
  private RedPacketDetailService redPacketDetailService;

  /**
   * 红包流水信息多条件分页查询
   *
   * @return
   */
  @ApiOperation(value = "红包流水多条件分页查询", notes = "分页参数为page和size，page从0开始，size默认50;")
  @GetMapping("findByConditions")
  public Result<Page<RedPacketDetailEntity>> findByConditions(@PageableDefault(50) Pageable pageable,
      @ApiParam(name = "terminalPaginationDto", value = "终端分页Dto") RedPacketDetailDto redPacketDetailDto) {
    try {
      Page<RedPacketDetailEntity> result = this.redPacketDetailService.findByConditions(pageable, redPacketDetailDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 方法内部流程：
   * 根据外部接口PolicyRewardServiceObserver获取入参
   * 根据奖励类型判定是否需要记录红包流水信息
   * 通过红包类型计算红包金额
   * 修改客户红包余额信息
   * 记录红包流水信息和客户红包信息
   *
   * @param redPacketDetailDto
   */
  @ApiOperation(value = "相关的创建过程，http接口。请注意该创建过程除了可以创建dealer中的基本信息以外，还可以对redPacketDetail中属于OneToMany关联的明细信息一同进行创建注意：基于（redPacketDetail）模型的创建操作传入的dealerJSON对象，其主键信息不能有值，服务端将会自动为其赋予相关值。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）")
  @PostMapping(value = "create")
  public Result<RedPacketDetailEntity> create(
      @RequestBody @ApiParam(name = "redPacketDetail", value = "相关的创建过程，http接口。请注意该创建过程除了可以创建dealer中的基本信息以外，还可以对redPacketDetail中属于OneToMany关联的明细信息一同进行创建注意：基于（redPacketDetail）模型的创建操作传入的redPacketDetailJSON对象，"
          + "其主键信息不能有值，服务端将会自动为其赋予相关值。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）") RedPacketDetailDto redPacketDetailDto) {
    try {
      RedPacketDetailEntity current = this.redPacketDetailService.create(redPacketDetailDto);
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
