package com.biz.crm.cps.business.reward.redpacket.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.LoginUserDetailsForCPS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.business.reward.redpacket.sdk.dto.RedPacketDetailDto;
import com.biz.crm.cps.business.reward.redpacket.sdk.service.RedPacketDetailVoService;
import com.biz.crm.cps.business.reward.redpacket.sdk.vo.RedPacketDetailVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Author: zengxingwang
 * @Date: 2021/8/7 14:20
 */
@Api(tags = "终端/经销商红包明细查看")
@Slf4j
@RestController
@RequestMapping("/v1/redPacket/detail")
public class RedPacketDetailVoController {

  @Autowired
  private RedPacketDetailVoService redPacketDetailVoService;
  @Autowired(required = false)
  private LoginUserService loginUserService;

  /**
   * 终端/经销商红包明细查看
   */
  @ApiOperation(value = "终端/经销商红包明细查看")
  @GetMapping(value="findByParticipatorCodeAndCreateTimeAndType")
  public Result<Page<RedPacketDetailVo>> findByParticipatorCodeAndCreateTimeAndType(@RequestParam(value = "yearAndMonth", required = false) @ApiParam(name="yearAndMonth" , value="年月(格式：yyyy-mm)") String yearAndMonth,
          @RequestParam(value = "type", required = false) @ApiParam(name="type" , value="type 1收入、2支出") String type, @PageableDefault(50) Pageable pageable) {
    try {
      LoginUserDetailsForCPS userDetails = loginUserService.getLoginDetails(LoginUserDetailsForCPS.class);
      Page<RedPacketDetailVo> page = redPacketDetailVoService.findByParticipatorCodeAndCreateTimeAndType(userDetails.getConsumerCode(), yearAndMonth, type,pageable);
      return Result.ok(page);
    } catch(RuntimeException e) {
      log.error(e.getMessage() , e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 红包流水信息多条件分页查询
   *
   * @return
   */
  @ApiOperation(value = "红包流水多条件分页查询", notes = "分页参数为page和size，page从0开始，size默认50;")
  @GetMapping("findByConditions")
  public Result<Page<RedPacketDetailVo>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                              @ApiParam(name = "terminalPaginationDto", value = "终端分页Dto") RedPacketDetailDto redPacketDetailDto) {
    try {
      Page<RedPacketDetailVo> result = this.redPacketDetailVoService.findByConditions(pageable, redPacketDetailDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }


  /**
   * 方法内部流程：
   * 根据外部接口PolicyRewardServiceObserver获取入参
   * 根据奖励类型判定是否需要记录红包流水信息
   * 通过红包类型计算红包金额
   * 修改客户红包余额信息
   * 记录红包流水信息和客户红包信息
   *
   * @param redPacketDetailDto
   */
  @ApiOperation(value = "创建流水")
  @PostMapping(value = "create")
  public Result<RedPacketDetailVo> create(@RequestBody @ApiParam(name = "redPacketDetail", value = "创建流水") RedPacketDetailDto redPacketDetailDto) {
    try {
      RedPacketDetailVo current = this.redPacketDetailVoService.create(redPacketDetailDto);
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
