package com.biz.crm.cps.business.reward.redpacket.local.controller;

import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.business.reward.redpacket.sdk.service.RedPacketRewardCashProcessVoService;
import com.biz.crm.cps.business.reward.sdk.vo.RewardCashProcessVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 红包提现接口
 *
 * @Author: hecheng
 */
@Api(tags = "红包提现接口")
@Slf4j
@RestController
@RequestMapping("/v1/redPacket/rewardCashProcessVo")
public class RedPacketRewardCashProcessVoController {

  @Autowired
  private RedPacketRewardCashProcessVoService redPacketRewardCashProcessVoService;


  /**
   * 查询当前用户 终端/经销商  提现流程
   *
   * @return
   */
  @ApiOperation(value = "查询当前用户终端/经销商 提现流程", notes = "查询当前用户终端/经销商 提现流程")
  @GetMapping("findByCurrentUser")
  public Result<RewardCashProcessVo> findByCurrentUser() {
    try {
      RewardCashProcessVo vo = this.redPacketRewardCashProcessVoService.findByCurrentUser();
      return Result.ok(vo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
