package com.biz.crm.cps.business.reward.redpacket.local.controller;

import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.business.reward.sdk.service.RewardCashVoService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.util.List;

/**
 * 红包提现接口
 *
 * @Author: hecheng
 */
@Api(tags = "红包提现接口")
@Slf4j
@RestController
@RequestMapping("/v1/redPacket/rewardCashVo")
public class RedPacketRewardCashVoController {

  @Autowired
  private RewardCashVoService rewardCashVoService;

  /**
   * 消费者扫码奖励统计
   *
   * @param recordCodes
   * @param openId
   * @return
   */
  @ApiOperation(value = "消费者扫码奖励统计")
  @GetMapping(value = "/findByConsumerOpenIdRecordCodes")
  public Result<BigDecimal> findByConsumerOpenIdRecordCodes(@RequestParam("recordCodes") List<String> recordCodes, @RequestParam("openId") String openId) {
    try {
      BigDecimal total = rewardCashVoService.findByConsumerOpenIdRecordCodes(openId, recordCodes);
      return Result.ok(total);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 终端/经销商红包提现
   *
   * @return
   */
  @ApiOperation(value = "终端/经销商红包提现", notes = "终端/经销商红包提现")
  @PostMapping("withdraw")
  public Result<Boolean> withdraw(@RequestParam("amount") BigDecimal amount, @RequestParam("operatorOpenId") String operatorOpenId, @RequestParam("caseKey") String caseKey) {
    try {
      this.rewardCashVoService.currentUserCash(amount, operatorOpenId, caseKey);
      return Result.ok(true);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 消费者红包提现
   *
   * @return
   */
  @ApiOperation(value = "消费者红包提现", notes = "消费者红包提现")
  @PostMapping("consumerWithdraw")
  public Result<Boolean> consumerWithdraw(@RequestParam("amount") BigDecimal amount, @RequestParam("openId") String openId) {
    try {
      this.rewardCashVoService.consumerCash(amount, openId);
      return Result.ok(true);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
