package com.biz.crm.cps.business.reward.redpacket.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 上账流水记录
 *
 * @Author: zengxingwang
 * @Date: 2021/8/5 16:25
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "KeepBooksDetailEntity", description = "上账流水记录")
@TableName("red_packet_keepbook_detail")
public class KeepBooksDetailEntity extends TenantOpEntity {
  /**
   * 
   */
  private static final long serialVersionUID = -371456518434990287L;

  /**
   * 编码
   */
  @ApiModelProperty("编码")
  @TableField(value = "code")
  private String code;

  /**
   * 上账金额
   */
  @ApiModelProperty("上账金额")
  @TableField(value = "amount")
  private BigDecimal amount;

  /**
   * 余额
   */
  @ApiModelProperty("余额")
  @TableField(value = "balance")
  private BigDecimal balance;

  /**
   * 备注
   */
  @ApiModelProperty("备注")
  @TableField(value = "remark")
  private String remark;

  /**
   * 上账id
   */
  @ApiModelProperty("上账id")
  @TableField(value = "keep_books_id")
  private String keepBooksId;

  /**
   * 上账信息
   */
  @ApiModelProperty("上账信息")
  @TableField(exist = false)
  private KeepBooksEntity keepBooks;
}
