package com.biz.crm.cps.business.reward.redpacket.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 上账记录
 *
 * @Author: zengxingwang
 * @Date: 2021/8/5 16:25
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "KeepBooksEntity", description = "上账记录")
@TableName("red_packet_keepbook")
public class KeepBooksEntity extends TenantOpEntity {

  /**
   *
   */
  private static final long serialVersionUID = -371456518434990287L;

  /**
   * 余额
   */
  @ApiModelProperty("余额")
  @TableField(value = "balance")
  private BigDecimal balance;

  /**
   * 备注
   */
  @ApiModelProperty("备注")
  @TableField(value = "remark")
  private String remark;
}
