package com.biz.crm.cps.business.reward.redpacket.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.cps.business.common.local.entity.BaseIdEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * 红包提现金额上限明细
 * @Author: zengxingwang
 * @Date: 2021/10/11 15:11
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MaxAmountLimitEntity", description = "红包提现金额上限明细")
@TableName("red_packet_max_amount_limit")
public class MaxAmountLimitEntity extends BaseIdEntity {

  /**
   * 时间类型（1.天：day；2.月：month）
   */
  @ApiModelProperty("时间类型（天：day；月：month）")
  @TableField(value = "time_type")
  private String timeType;

  /**
   * 金额限制
   */
  @ApiModelProperty("金额限制")
  @TableField(value = "amount_limit")
  private BigDecimal amountLimit;

  /**
   * 红包权益配置
   */
  @ApiModelProperty("红包权益配置")
  @TableField(value = "red_packet_config_id")
  private String redPacketConfigId;

  /**
   * 红包权益配置
   */
  @ApiModelProperty("红包权益配置")
  @TableField(exist = false)
  private RedPacketConfigEntity config;
}
