package com.biz.crm.cps.business.reward.redpacket.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.Set;

/**
 * 红包权益配置
 * @Author: zengxingwang
 * @Date: 2021/8/5 10:32
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "RedPacketConfigEntity", description = "红包权益配置")
@TableName("red_packet_config")
public class RedPacketConfigEntity extends TenantOpEntity {

  /**
   * 类型（1.经销商2.终端3.消费者）
   */
  @ApiModelProperty("类型（1.经销商2.终端3.消费者4.导购）")
  @TableField(value = "type")
  private String type;

  /**
   * 红包提现门槛金额是否限制(0.不限制1.限制)
   */
  @ApiModelProperty("红包提现门槛金额是否限制(0.不限制1.限制)")
  @TableField(value = "is_amount_limit")
  private Integer isAmountLimit;

  /**
   * 红包提现门槛金额
   */
  @ApiModelProperty("红包提现门槛金额")
  @TableField(value = "amount_limit")
  private BigDecimal amountLimit;

  /**
   * 单次红包提现金额是否限制(0.不限制1.限制)
   */
  @ApiModelProperty("单次红包提现金额是否限制(0.不限制1.限制)")
  @TableField(value = "is_one_amount_limit")
  private Integer isOneCountLimit;

  /**
   * 单次红包提现金额
   */
  @ApiModelProperty("单次红包提现金额")
  @TableField(value = "one_amount_limit")
  private BigDecimal oneAmountLimit;

  /**
   * 红包提现金额上限设置(0.不限制1.限制)
   */
  @ApiModelProperty("红包提现金额上限设置(0.不限制1.限制)")
  @TableField(value = "is_max_amount_limit")
  private Integer isMaxAmountLimit;

  /**
   * 红包提现金额上限明细
   */
  @ApiModelProperty("红包提现金额上限明细")
  @TableField(exist = false)
  private Set<MaxAmountLimitEntity> amountLimitDetails;

  /**
   * 红包提现次数上限设置(0.不限制1.限制)
   */
  @ApiModelProperty("红包提现次数上限设置(0.不限制1.限制)")
  @TableField(value = "is_max_count_limit")
  private Integer isMaxCountLimit;

  /**
   * 红包提现次数上限明细
   */
  @ApiModelProperty("红包提现次数上限明细")
  @TableField(exist = false)
  private Set<MaxCountLimitEntity> countLimitDetails;

  /**
   * 红包提现规则
   */
  @ApiModelProperty("红包提现规则")
  @TableField(value = "description")
  private String description;
}
