package com.biz.crm.cps.business.reward.redpacket.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * 红包流水明细
 *
 * @Author: zengxingwang
 * @Date: 2021/8/5 10:32
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "RedPacketDetailEntity", description = "红包流水明细")
@TableName("red_packet_detail")
public class RedPacketDetailEntity extends TenantFlagOpEntity {

  private static final long serialVersionUID = -5387176716047899897L;

  /**
   * 红包变动流水编码
   */
  @ApiModelProperty("红包变动流水编码")
  @TableField(value = "code")
  private String code;

  /**
   * 参与者类型
   */
  @ApiModelProperty("参与者类型")
  @TableField(value = "participator_type")
  private String participatorType;

  /**
   * 参与者编码
   */
  @ApiModelProperty("参与者编码")
  @TableField(value = "participator_code")
  private String participatorCode;

  /**
   * 参与者名称
   */
  @ApiModelProperty("参与者名称")
  @TableField(value = "participator_name")
  private String participatorName;

  /**
   * 手机号
   */
  @ApiModelProperty("手机号")
  @TableField(value = "phone")
  private String phone;

  /**
   *
   * <pre>
   * 1、红包提现；
   * 2、惩罚扣除（可能有）；
   * 3、扫箱码；
   * 4、扫盖内码；
   * 5、扫盒码；
   * 6、包量任务分利；
   * 7、陈列任务分利；
   * 8、支付扫码分利（后续控价涉及）；
   * </pre>
   * 触发动作
   */
  @ApiModelProperty("触发动作")
  @TableField(value = "trigger_action ")
  private String triggerAction;

  /**
   * 触发对象
   */
  @ApiModelProperty("触发对象")
  @TableField(value = "trigger_object")
  private String triggerObject;


  /**
   * 变动金额
   */
  @ApiModelProperty("变动金额")
  @TableField(value = "amount")
  private BigDecimal amount;

  /**
   * 红包余额
   */
  @ApiModelProperty("红包余额")
  @TableField(value = "balance")
  private BigDecimal balance;

  /**
   * 红包
   */
  @ApiModelProperty("红包")
  @TableField(value = "red_packet_id")
  private String redPacketId;
  /**
   * 协议模版编码
   */
  @ApiModelProperty("协议模版编码")
  @TableField(value = "template_code")
  private String templateCode;

  /**
   * 协议编码
   */
  @ApiModelProperty("协议编码")
  @TableField(value = "agreement_code")
  private String agreementCode;
  /**
   * 触发动作所属政策
   */
  @ApiModelProperty("政策名称")
  @TableField(value = "policy_name")
  private String policyName;
  /**
   * 扫码记录编码
   */
  @ApiModelProperty("扫码记录编码")
  @TableField(value = "record_code")
  private String recordCode;

  /**
   * 操作类型，1：增加 2：减少
   */
  @ApiModelProperty("操作类型，1：增加 2：减少")
  @TableField(value = "type")
  private String type;
  /**
   * 红包信息
   */
  @ApiModelProperty("红包信息")
  @TableField(exist = false)
  private RedPacketEntity redPacket;

  /**
   * 返利类型 (正向，反向)
   */
  @ApiModelProperty("返利类型 (正向，反向)")
  @TableField(value = "rebate_type")
  private String rebateType;

  /**
   * 关联业务类型
   *
   * @see RewardRelateTypeEnum dictCode
   */
  @ApiModelProperty("关联业务类型")
  @TableField(value = "relate_type")
  private String relateType;

  /** 关联业务流号 协议活动号、扫码活动编码 */
  @ApiModelProperty("关联业务流号-协议活动号、扫码活动编码")
  @TableField(value = "relate_code")
  private String relateCode;
}
