package com.biz.crm.cps.business.reward.redpacket.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Set;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 红包流水汇总
 *
 * @Author: zengxingwang
 * @Date: 2021/8/5 10:32
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "RedPacketEntity", description = "红包流水汇总")
@TableName("red_packet")
public class RedPacketEntity extends TenantFlagOpEntity {
  private static final long serialVersionUID = 8190467636664597283L;

  /**
   * 参与者编码
   */
  @ApiModelProperty("客户编码")
  @TableField(value = "participator_code")
  private String participatorCode;

  /**
   * 参与者名称
   */
  @ApiModelProperty("客户名称")
  @TableField(value = "participator_name")
  private String participatorName;

  /**
   * 参与者类型
   */
  @ApiModelProperty("客户类型")
  @TableField(value = "participator_type")
  private String participatorType;

  /**
   * 渠道类型
   */
  @ApiModelProperty("渠道类型")
  @TableField(value = "channel")
  private String channel;

  /**
   * 客户标签
   */
  @ApiModelProperty("客户标签")
  @TableField(value = "tag")
  private String tag;

  /**
   * 所属组织编码
   */
  @ApiModelProperty("所属组织编码")
  @TableField(value = "org_code")
  private String orgCode;

  /**
   * 所属组织名称
   */
  @ApiModelProperty("所属组织名称")
  @TableField(value = "org_name")
  private String orgName;

  /**
   * 红包余额
   */
  @ApiModelProperty("红包余额")
  @TableField(value = "balance")
  private BigDecimal balance;

  /**
   * 累计分利红包
   */
  @ApiModelProperty("累计分利红包")
  @TableField(value = "accruing_red_packet")
  private BigDecimal accruingRedPacket;

  /**
   * 联系电话
   */
  @ApiModelProperty("联系电话")
  @TableField(value = "phone")
  private String phone;

  /**
   * 明细
   */
  @ApiModelProperty("明细")
  @TableField(exist = false)
  private Set<RedPacketDetailEntity> details;
}
