package com.biz.crm.cps.business.reward.redpacket.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.reward.redpacket.local.entity.KeepBooksDetailEntity;
import com.biz.crm.cps.business.reward.redpacket.sdk.dto.KeepBooksDetailDto;
import java.math.BigDecimal;
import org.apache.ibatis.annotations.Param;

/**
 * @ClassName: KeepBooksDetailMapper
 * @Author: yangfan
 * @Description: 上账流水记录mapper
 * @Date: 2021/8/7 16:00
 * @Version: 1.0
 */
public interface KeepBooksDetailMapper extends BaseMapper<KeepBooksDetailEntity> {

  /**
   * 分页条件查询上账记录信息
   *
   * @param page
   * @param dto
   * @return
   */
  Page<KeepBooksDetailEntity> findByConditions(Page<KeepBooksDetailEntity> page,
      @Param("dto") KeepBooksDetailDto dto);

  /**
   * 昨日上账
   * @param lastDay
   * @return
   */
  BigDecimal sumByLastDay(@Param("lastDay") String lastDay);
}
