package com.biz.crm.cps.business.reward.redpacket.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.cps.business.reward.redpacket.local.entity.KeepBooksEntity;
import java.math.BigDecimal;
import org.apache.ibatis.annotations.Param;

/**
 * @ClassName: KeepBooksMapper
 * @Author: yangfan
 * @Description: 上账记录mapper
 * @Date: 2021/8/7 16:00
 * @Version: 1.0
 */
public interface KeepBooksMapper extends BaseMapper<KeepBooksEntity> {

  /**
   * 扣减指定记录的余额
   *
   * @param id
   * @param amount
   * @param modifyAccount
   */
  long subtractBalance(@Param("id") String id, @Param("amount") BigDecimal amount, @Param("modifyAccount") String modifyAccount);

  /**
   * 新增指定记录的余额
   *
   * @param id
   * @param amount
   * @param modifyAccount
   */
  long addBalance(@Param("id") String id, @Param("amount") BigDecimal amount, @Param("modifyAccount") String modifyAccount);

  /**
   * 按id查询余额
   *
   * @param id
   * @return
   */
  BigDecimal findBalanceById(@Param("id") String id);
}
