package com.biz.crm.cps.business.reward.redpacket.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.reward.redpacket.local.entity.RedPacketDetailEntity;
import com.biz.crm.cps.business.reward.redpacket.sdk.dto.RedPacketDetailDto;
import org.apache.ibatis.annotations.Param;
import java.math.BigDecimal;
import java.util.List;

/**
 * @ClassName: RedPacketDetailMapper
 * @Author: yangfan
 * @Description: 红包流水mapper
 * @Date: 2021/8/7 14:15
 * @Version: 1.0
 */
public interface RedPacketDetailMapper extends BaseMapper<RedPacketDetailEntity> {

  /**
   * 分页条件查询红包流水信息F
   *
   * @param page
   * @param dto
   * @return
   */
  Page<RedPacketDetailEntity> findByConditions(Page<RedPacketDetailEntity> page, @Param("dto") RedPacketDetailDto dto);

  /**
   * 根据参与者编码查询最新一条流水信息
   *
   * @param participatorCode
   * @return
   */
  RedPacketDetailEntity findTop1ByParticipatorCode(@Param("participatorCode") String participatorCode);

  /**
   *
   * @param lastDay 格式：YYYY-MM-DD
   * @return
   */
  BigDecimal sumByLastDay(@Param("lastDay") String lastDay);

  /**
   * 根据参与者编码和时间查询
   *
   * @param participatorCode
   * @param yearAndMonth
   * @return
   */
  List<RedPacketDetailEntity> findByParticipatorCodeAndCreateTime(@Param("participatorCode") String participatorCode, @Param("yearAndMonth") String yearAndMonth);

  /**
   * 收益计算 按 参与者code 和扫码code集合汇总获得的分利
   *
   * @param participatorCode
   * @param recordCodes
   * @return
   */
  BigDecimal sumByParticipatorCodeAndRecordCodes(@Param("participatorCode") String participatorCode, @Param("recordCodes") List<String> recordCodes);

  /**
   * 按租户和触发动作统计
   * @param tenantCode
   * @param triggerAction
   * @return
   */
  BigDecimal sumByTenantCodeAndTriggerAction(@Param("tenantCode")String tenantCode, @Param("triggerAction")String triggerAction);

}
