package com.biz.crm.cps.business.reward.redpacket.local.mapper;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.reward.redpacket.sdk.dto.RedPacketDetailDto;
import com.biz.crm.cps.business.reward.redpacket.sdk.vo.RedPacketDetailVo;
import org.apache.ibatis.annotations.Param;

/**
 * @ClassName: RedPacketDetailMapper
 * @Author: yangfan
 * @Description: 红包流水mapper
 * @Date: 2021/8/7 14:15
 * @Version: 1.0
 */
public interface RedPacketDetailVoMapper {

  /**
   * 分页条件查询红包流水信息F
   *
   * @param page
   * @param dto
   * @return
   */
  Page<RedPacketDetailVo> findByConditions(Page<RedPacketDetailVo> page, @Param("dto") RedPacketDetailDto dto);

  /**
   * 消费者红包流水
   * @param page
   * @param dto
   * @return
   */
  Page<RedPacketDetailVo> findConsumerByConditions(Page<RedPacketDetailVo> page, @Param("dto") RedPacketDetailDto dto);

  /**
   * 终端红包流水
   * @param page
   * @param dto
   * @return
   */
  Page<RedPacketDetailVo> findTerminalByConditions(Page<RedPacketDetailVo> page, @Param("dto") RedPacketDetailDto dto);

  /**
   * 经销商红包流水
   * @param page
   * @param dto
   * @return
   */
  Page<RedPacketDetailVo> findDealerByConditions(Page<RedPacketDetailVo> page, @Param("dto") RedPacketDetailDto dto);
}
