package com.biz.crm.cps.business.reward.redpacket.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.reward.redpacket.local.entity.RedPacketEntity;
import com.biz.crm.cps.business.reward.redpacket.sdk.dto.CustomerRedPacketBalanceDto;
import java.math.BigDecimal;
import org.apache.ibatis.annotations.Param;


/**
 * @Author: zengxingwang
 * @Date: 2021/8/7 14:35
 */
public interface RedPacketMapper extends BaseMapper<RedPacketEntity> {

  /**
   * 条件查询分客户红包列表
   * @param page
   * @param balanceDto
   * @return
   */
  Page<RedPacketEntity> findByConditions(Page<RedPacketEntity> page, @Param("balanceDto") CustomerRedPacketBalanceDto balanceDto);

  /**
   * 通过参与者编码查询红包信息
   * @param participatorCode
   * @return
   */
  RedPacketEntity findByParticipatorCode(@Param("participatorCode") String participatorCode);
  /**
   * 为指定参与者增加余额
   * @param participatorCode
   * @param amount
   * @return
   */
  long addBalance(@Param("participatorCode") String participatorCode, @Param("amount") BigDecimal amount);
  /**
   * 为指定参与者减少余额
   * @param participatorCode
   * @param amount
   * @return
   */
  long subtractBalance(@Param("participatorCode") String participatorCode, @Param("amount") BigDecimal amount);

  /**
   * 查询参与者余额
   * @param participatorCode
   * @return
   */
  BigDecimal findBalanceByParticipatorCode(@Param("participatorCode")String participatorCode);
}
