package com.biz.crm.cps.business.reward.redpacket.local.mapper;

import com.biz.crm.cps.business.reward.sdk.vo.ParticipatorRewardStatisticsVo;
import java.util.List;
import org.apache.ibatis.annotations.Param;

/**
 * 参与者统计汇总收益
 *
 * @author hecheng
 * @date 2021/08/27
 */
public interface RedPacketParticipatorRewardStatisticsVoMapper {

  /**
   * 按 参与者code集合汇总获得的分利
   *
   * @param participatorCodes
   * @return
   */
  List<ParticipatorRewardStatisticsVo> findByParticipatorCodes(
      @Param("participatorCodes") List<String> participatorCodes);

  /**
   * 今日收益
   *
   * @param participatorCodes
   * @param today
   * @return
   */
  List<ParticipatorRewardStatisticsVo> findTodayAmountByParticipatorCodes(
      @Param("participatorCodes") List<String> participatorCodes, @Param("today") String today);
}
