package com.biz.crm.cps.business.reward.redpacket.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.reward.redpacket.local.entity.KeepBooksDetailEntity;
import com.biz.crm.cps.business.reward.redpacket.local.mapper.KeepBooksDetailMapper;
import com.biz.crm.cps.business.reward.redpacket.sdk.dto.KeepBooksDetailDto;
import java.math.BigDecimal;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * @ClassName: KeepBooksRepository
 * @Author: yangfan
 * @Description: 上账记录调用数据库操作类
 * @Date: 2021/8/7 15:56
 * @Version: 1.0
 */

@Component
public class KeepBooksDetailRepository extends ServiceImpl<KeepBooksDetailMapper, KeepBooksDetailEntity> {


  /**
   * 分页条件查询上账记录信息
   *
   * @param pageable
   * @param dto
   * @return
   */
  public Page<KeepBooksDetailEntity> findByConditions(Pageable pageable, KeepBooksDetailDto dto) {
    Page<KeepBooksDetailEntity> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.baseMapper.findByConditions(page, dto);
  }

  /**
   * 昨日上账
   *
   * @param lastDay
   * @return
   */
  public BigDecimal sumByLastDay(String lastDay) {
    return this.baseMapper.sumByLastDay(lastDay);
  }

}
