package com.biz.crm.cps.business.reward.redpacket.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.reward.redpacket.local.entity.KeepBooksEntity;
import com.biz.crm.cps.business.reward.redpacket.local.mapper.KeepBooksMapper;
import java.math.BigDecimal;
import org.springframework.stereotype.Component;

/**
 * @ClassName: KeepBooksRepository
 * @Author: yangfan
 * @Description: 上账记录调用数据库操作类
 * @Date: 2021/8/7 15:56
 * @Version: 1.0
 */

@Component
public class KeepBooksRepository extends ServiceImpl<KeepBooksMapper, KeepBooksEntity> {


  /**
   * 扣减指定记录的余额
   *
   * @param id
   * @param amount
   */
  public long subtractBalance(String id, BigDecimal amount, String modifyAccount) {
    return this.baseMapper.subtractBalance(id, amount, modifyAccount);
  }

  /**
   * 新增指定记录的余额
   *
   * @param id
   * @param amount
   * @param modifyAccount
   */
  public long addBalance(String id, BigDecimal amount, String modifyAccount) {
    return this.baseMapper.addBalance(id, amount, modifyAccount);
  }

  /**
   * 按租户查询红包余额
   *
   * @param tenantCode
   * @return
   */
  public KeepBooksEntity findByTenantCode(String tenantCode) {
    return this.lambdaQuery().eq(KeepBooksEntity::getTenantCode, tenantCode).one();
  }

  /**
   * 按id查询余额
   * @param id
   * @return
   */
  public BigDecimal findBalanceById(String id) {
    return this.baseMapper.findBalanceById(id);
  }
}
