package com.biz.crm.cps.business.reward.redpacket.local.repository;


import com.biz.crm.cps.business.reward.redpacket.local.mapper.RedPacketAgreementRewardStatisticsVoMapper;
import com.biz.crm.cps.business.reward.sdk.vo.AgreementRewardStatisticsVo;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author hecheng
 * @description: 协议统计汇总收益
 * @date 2021/8/27 下午7:52
 */
@Component
public class RedPacketAgreementRewardStatisticsVoRepository {

  @Autowired
  private RedPacketAgreementRewardStatisticsVoMapper redPacketAgreementRewardStatisticsVoMapper;

  /**
   * 按 参与者code 和扫码code集合汇总获得的分利
   *
   * @param participatorCode
   * @param templateCodes
   * @return
   */
  public List<AgreementRewardStatisticsVo> findByParticipatorCodeAndTemplateCodes(String participatorCode, List<String> templateCodes) {
    return this.redPacketAgreementRewardStatisticsVoMapper.findByParticipatorCodeAndTemplateCodes(participatorCode, templateCodes);
  }
}
