package com.biz.crm.cps.business.reward.redpacket.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.reward.redpacket.local.entity.RedPacketConfigEntity;
import com.biz.crm.cps.business.reward.redpacket.local.mapper.RedPacketConfigMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 红包权益配置实现持久化
 * @Author: zengxingwang
 * @Date: 2021/10/11 15:45
 */
@Component
public class RedPacketConfigRepository extends ServiceImpl<RedPacketConfigMapper, RedPacketConfigEntity> {

  @Autowired
  private RedPacketConfigMapper redPacketConfigMapper;

  /**
   * 查询所有配置
   * @return
   */
  public List<RedPacketConfigEntity> findAll() {
    return redPacketConfigMapper.findAll();
  }

  /**
   * 根据id查询
   * @param id
   * @return
   */
  public RedPacketConfigEntity findById(String id) {
    return redPacketConfigMapper.selectById(id);
  }
}
