package com.biz.crm.cps.business.reward.redpacket.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.reward.redpacket.local.entity.RedPacketDetailEntity;
import com.biz.crm.cps.business.reward.redpacket.local.mapper.RedPacketDetailMapper;
import com.biz.crm.cps.business.reward.redpacket.sdk.dto.RedPacketDetailDto;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * @ClassName: RedPacketDetailRepository
 * @Author: yangfan
 * @Description: 红包流水实体数据库操作类
 * @Date: 2021/8/7 14:58
 * @Version: 1.0
 */
@Component
public class RedPacketDetailRepository extends
    ServiceImpl<RedPacketDetailMapper, RedPacketDetailEntity> {

  @Autowired
  private RedPacketDetailMapper redPacketDetailMapper;

  /**
   * 分页条件查询红包流水信息
   *
   * @param pageable
   * @param dto
   * @return
   */
  public Page<RedPacketDetailEntity> findByConditions(Pageable pageable, RedPacketDetailDto dto) {
    Page<RedPacketDetailEntity> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.redPacketDetailMapper.findByConditions(page, dto);
  }

  /**
   * 根据参与者编码查询最新一条流水信息
   *
   * @param participatorCode
   * @return
   */
  public RedPacketDetailEntity findTop1ByParticipatorCode(String participatorCode) {
    return this.redPacketDetailMapper.findTop1ByParticipatorCode(participatorCode);
  }

  /**
   * 昨日发放
   * @param lastDay 格式：YYYY-MM-DD
   * @return
   */
  public BigDecimal sumByLastDay(String lastDay) {
    return this.redPacketDetailMapper.sumByLastDay(lastDay);
  }

  /**
   * 根据参与者编码和时间查询
   * @param participatorCode
   * @param yearAndMonth 格式:YYYY-MM
   * @return
   */
  public List<RedPacketDetailEntity> findByParticipatorCodeAndCreateTime(String participatorCode, String yearAndMonth) {
    return this.redPacketDetailMapper.findByParticipatorCodeAndCreateTime(participatorCode, yearAndMonth);
  }
  /**
   * 按 参与者code 和扫码code集合汇总获得的分利
   * @param participatorCode
   * @param recordCodes
   * @return
   */
  public BigDecimal sumByParticipatorCodeAndRecordCodes(String participatorCode, List<String> recordCodes) {
    return this.redPacketDetailMapper.sumByParticipatorCodeAndRecordCodes(participatorCode,recordCodes);
  }
  /**
   * 按租户和触发动作统计
   * @param tenantCode
   * @param triggerAction
   * @return
   */
  public BigDecimal sumByTenantCodeAndTriggerAction(String tenantCode, String triggerAction) {
    return this.redPacketDetailMapper.sumByTenantCodeAndTriggerAction(tenantCode,triggerAction);
  }
}
