package com.biz.crm.cps.business.reward.redpacket.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.reward.redpacket.local.mapper.RedPacketDetailVoMapper;
import com.biz.crm.cps.business.reward.redpacket.sdk.dto.RedPacketDetailDto;
import com.biz.crm.cps.business.reward.redpacket.sdk.vo.RedPacketDetailVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * @ClassName: RedPacketDetailRepository
 * @Author: yangfan
 * @Description: 红包流水实体数据库操作类
 * @Date: 2021/8/7 14:58
 * @Version: 1.0
 */
@Component
public class RedPacketDetailVoRepository {

  @Autowired
  private RedPacketDetailVoMapper redPacketDetailVoMapper;

  /**
   * 分页条件查询红包流水信息
   *
   * @param pageable
   * @param dto
   * @return
   */
  public Page<RedPacketDetailVo> findByConditions(Pageable pageable, RedPacketDetailDto dto) {
    Page<RedPacketDetailVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.redPacketDetailVoMapper.findByConditions(page, dto);
  }

  /**
   * 消费者红包流水
   * @param pageable
   * @param dto
   * @return
   */
  public Page<RedPacketDetailVo> findConsumerByConditions(Pageable pageable, RedPacketDetailDto dto) {
    Page<RedPacketDetailVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.redPacketDetailVoMapper.findConsumerByConditions(page,dto);
  }

  /**
   * 终端红包流水
   * @param pageable
   * @param dto
   * @return
   */
  public Page<RedPacketDetailVo> findTerminalByConditions(Pageable pageable, RedPacketDetailDto dto) {
    Page<RedPacketDetailVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.redPacketDetailVoMapper.findTerminalByConditions(page,dto);
  }

  /**
   * 经销商红包流水
   * @param pageable
   * @param dto
   * @return
   */
  public Page<RedPacketDetailVo> findDealerByConditions(Pageable pageable, RedPacketDetailDto dto) {
    Page<RedPacketDetailVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.redPacketDetailVoMapper.findDealerByConditions(page,dto);
  }
}
