package com.biz.crm.cps.business.reward.redpacket.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.reward.redpacket.local.entity.RedPacketEntity;
import com.biz.crm.cps.business.reward.redpacket.local.mapper.RedPacketMapper;
import com.biz.crm.cps.business.reward.redpacket.sdk.dto.CustomerRedPacketBalanceDto;
import com.biz.crm.cps.business.reward.redpacket.sdk.dto.RedPacketDto;
import java.math.BigDecimal;
import org.apache.commons.lang.StringUtils;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * 红包流水汇总数据层服务
 *
 * @Author: zengxingwang
 * @Date: 2021/8/7 14:32
 */
@Component
public class RedPacketRepository extends ServiceImpl<RedPacketMapper, RedPacketEntity> {



  /**
   * 条件查询分客户红包列表
   *
   * @param pageable
   * @param balanceDto
   * @return
   */
  public Page<RedPacketEntity> findByConditions(Pageable pageable, CustomerRedPacketBalanceDto balanceDto) {
    Page<RedPacketEntity> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.baseMapper.findByConditions(page, balanceDto);
  }

  /**
   * 通过参与者编码查询红包信息
   *
   * @param participatorCode
   * @return
   */
  public RedPacketEntity findByParticipatorCode(String participatorCode) {
    return this.baseMapper.findByParticipatorCode(participatorCode);
  }

  /**
   * 为指定参与者增加余额
   * @param participatorCode
   * @param amount
   * @return
   */
  public long addBalance(String participatorCode, BigDecimal amount) {
    return this.baseMapper.addBalance(participatorCode,amount);
  }
  /**
   * 为指定参与者减少余额
   * @param participatorCode
   * @param amount
   * @return
   */
  public long subtractBalance(String participatorCode, BigDecimal amount) {
    return this.baseMapper.subtractBalance(participatorCode,amount);
  }

  /**
   * 查询参与者余额
   * @param participatorCode
   * @return
   */
  public BigDecimal findBalanceByParticipatorCode(String participatorCode) {
    return this.baseMapper.findBalanceByParticipatorCode(participatorCode);
  }

  /**
   *
   * @param redPacketDto
   */
  public void updateBaseInfo(RedPacketDto redPacketDto) {
    this.lambdaUpdate().set(StringUtils.isNotBlank(redPacketDto.getChannel()),RedPacketEntity::getChannel,redPacketDto.getChannel())
            .set(StringUtils.isNotBlank(redPacketDto.getOrgName()),RedPacketEntity::getOrgName,redPacketDto.getOrgName())
            .set(StringUtils.isNotBlank(redPacketDto.getOrgCode()),RedPacketEntity::getOrgCode,redPacketDto.getOrgCode())
            .set(StringUtils.isNotBlank(redPacketDto.getTag()),RedPacketEntity::getTag,redPacketDto.getTag())
            .eq(RedPacketEntity::getParticipatorCode,redPacketDto.getParticipatorCode()).update();
  }
}
