package com.biz.crm.cps.business.reward.redpacket.local.repository;


import com.biz.crm.cps.business.reward.redpacket.local.mapper.RedPacketScanCodeRewardStatisticsVoMapper;
import com.biz.crm.cps.business.reward.sdk.vo.ScanCodeRewardStatisticsVo;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author hecheng
 * @description: 扫码统计汇总收益
 * @date 2021/8/27 下午7:52
 */
@Component
public class RedPacketScanCodeRewardStatisticsVoRepository {

  @Autowired
  private RedPacketScanCodeRewardStatisticsVoMapper redPacketScanCodeRewardStatisticsVoMapper;

  /**
   * 按 参与者code 和扫码code集合汇总获得的分利
   *
   * @param participatorCode
   * @param recordCodes
   * @return
   */
  public List<ScanCodeRewardStatisticsVo> findByParticipatorCodeAndRecordCodes(String participatorCode, List<String> recordCodes) {
    return this.redPacketScanCodeRewardStatisticsVoMapper.findByParticipatorCodeAndRecordCodes(participatorCode, recordCodes);
  }
}
