package com.biz.crm.cps.business.reward.redpacket.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.reward.redpacket.local.entity.KeepBooksDetailEntity;
import com.biz.crm.cps.business.reward.redpacket.sdk.dto.KeepBooksDetailDto;
import com.biz.crm.cps.business.reward.redpacket.sdk.dto.KeepBooksDto;
import java.math.BigDecimal;
import org.springframework.data.domain.Pageable;

/**
 * @ClassName: KeepBooksService
 * @Author: yangfan
 * @Description: 上账记录service
 * @Date: 2021/8/7 15:46
 * @Version: 1.0
 */

public interface KeepBooksDetailService {

  /**
   * 分页条件查询上账记录信息
   *
   * @param pageable
   * @param dto
   * @return
   */
  Page<KeepBooksDetailEntity> findByConditions(Pageable pageable, KeepBooksDetailDto dto);

  /**
   * 昨日上账
   *
   * @param lastDay
   * @return
   */
  BigDecimal sumByLastDay(String lastDay);

  /**
   * 创建上账流水
   *
   * @param keepBooksDetailDto
   * @return
   */
  KeepBooksDetailEntity create(KeepBooksDetailDto keepBooksDetailDto);
}
