package com.biz.crm.cps.business.reward.redpacket.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.reward.redpacket.local.entity.KeepBooksEntity;
import com.biz.crm.cps.business.reward.redpacket.sdk.dto.KeepBooksDto;
import org.springframework.data.domain.Pageable;

import java.math.BigDecimal;

/**
 * @ClassName: KeepBooksService
 * @Author: yangfan
 * @Description: 上账记录service
 * @Date: 2021/8/7 15:46
 * @Version: 1.0
 */

public interface KeepBooksService {

  /**
   * 更新最新一条上账记录余额(减法)
   * @param amount
   */
  void updateTop1SubBalance(BigDecimal amount);

  /**
   * 创建
   * @param keepBooksDto
   * @return
   */
  KeepBooksEntity create(KeepBooksDto keepBooksDto);

  /**
   * 按租户查询 红包上账余额
   * @param tenantCode
   * @return
   */
  KeepBooksEntity findByTenantCode(String tenantCode);

  /**
   * 按 账户查询余额
   * @param id
   * @return
   */
  BigDecimal findBalanceById(String id);
}
