package com.biz.crm.cps.business.reward.redpacket.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.reward.redpacket.local.entity.RedPacketDetailEntity;
import com.biz.crm.cps.business.reward.redpacket.sdk.dto.RedPacketDetailDto;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.data.domain.Pageable;

/**
 * @ClassName: RedPacketDetailService
 * @Author: yangfan
 * @Description: 红包详情service
 * @Date: 2021/8/7 14:51
 * @Version: 1.0
 */
public interface RedPacketDetailService {

  /**
   * 分页条件查询红包流水信息
   *
   * @param pageable
   * @param dto
   * @return
   */
  Page<RedPacketDetailEntity> findByConditions(Pageable pageable, RedPacketDetailDto dto);

  /**
   * 红包流水新增
   *
   * @param redPacketDetailDto
   * @return
   */
  RedPacketDetailEntity create(RedPacketDetailDto redPacketDetailDto);
  /**
   * 更新红包流水
   * @param redPacketDetail
   */
  RedPacketDetailEntity update(RedPacketDetailEntity redPacketDetail);
  /**
   * 昨日发放
   *
   * @param lastDay 格式：YYYY-MM-DD
   * @return
   */
  BigDecimal sumByLastDay(String lastDay);

  /**
   * 根据参与者编码和时间查询
   *
   * @param participatorCode
   * @param yearAndMonth 格式:YYYY-MM
   * @return
   */
  List<RedPacketDetailEntity> findByParticipatorCodeAndCreateTime(String participatorCode, String yearAndMonth);
  /**
   * 按 参与者code 和扫码code集合汇总获得的分利
   * @param participatorCode
   * @param recordCodes
   * @return
   */
  BigDecimal sumByParticipatorCodeAndRecordCodes(String participatorCode, List<String> recordCodes);

  /**
   * 按租户和触发动作统计
   * @param tenantCode
   * @param triggerAction
   * @return
   */
  BigDecimal sumByTenantCodeAndTriggerAction(String tenantCode, String triggerAction);


}
