package com.biz.crm.cps.business.reward.redpacket.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.reward.redpacket.local.entity.RedPacketEntity;
import com.biz.crm.cps.business.reward.redpacket.sdk.dto.CustomerRedPacketBalanceDto;
import com.biz.crm.cps.business.reward.redpacket.sdk.dto.RedPacketDto;
import com.biz.crm.cps.business.reward.sdk.common.enums.IncomeStatusEnum;
import com.biz.crm.cps.business.reward.sdk.vo.ParticipatorRewardStatisticsVo;
import com.biz.crm.cps.business.reward.sdk.vo.ScanCodeRewardStatisticsVo;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.data.domain.Pageable;

/**
 * @Author: zengxingwang
 * @Date: 2021/8/7 14:28
 */
public interface RedPacketService {

  /**
   * 条件查询分客户红包列表
   *
   * @param balanceDto
   * @param pageable
   * @return
   */
  Page<RedPacketEntity> findByConditions(CustomerRedPacketBalanceDto balanceDto, Pageable pageable);

  /**
   * 通过参与者编码查询红包信息
   *
   * @param participatorCode
   * @return
   */
  RedPacketEntity findByParticipatorCode(String participatorCode);

  /**
   * 红包新增
   *
   * @param redPacketDto
   * @return
   */
  RedPacketEntity create(RedPacketDto redPacketDto);

  /**
   * 红包更新
   *
   * @param redPacketDto
   * @return
   */
  RedPacketEntity update(RedPacketDto redPacketDto);

  /**
   * 根据参与者code 和收入状态更新余额
   * @param participatorCode
   * @param amount
   * @param incomeStatus
   * @return
   */
  void updateBalance(String participatorCode,BigDecimal amount, IncomeStatusEnum incomeStatus);

  /**
   * 更新基础信息
   * @param redPacketDto
   */
  void updateBaseInfo(RedPacketDto redPacketDto);

  /**
   * 查询参与者余额
   * @param participatorCode
   * @return
   */
  BigDecimal findBalanceByParticipatorCode(String participatorCode);

}
