package com.biz.crm.cps.business.reward.redpacket.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.reward.redpacket.local.entity.KeepBooksDetailEntity;
import com.biz.crm.cps.business.reward.redpacket.local.entity.KeepBooksEntity;
import com.biz.crm.cps.business.reward.redpacket.local.repository.KeepBooksDetailRepository;
import com.biz.crm.cps.business.reward.redpacket.local.service.KeepBooksDetailService;
import com.biz.crm.cps.business.reward.redpacket.local.service.KeepBooksService;
import com.biz.crm.cps.business.reward.redpacket.sdk.common.constant.RedPacketCodeConstant;
import com.biz.crm.cps.business.reward.redpacket.sdk.dto.KeepBooksDetailDto;
import com.biz.crm.cps.business.reward.redpacket.sdk.dto.KeepBooksDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;

/**
 * @ClassName: KeepBooksServiceImpl
 * @Author: yangfan
 * @Description: 上账记录实现类
 * @Date: 2021/8/7 15:50
 * @Version: 1.0
 */

@Service
public class KeepBooksDetailServiceImpl implements KeepBooksDetailService {

  @Autowired
  private KeepBooksDetailRepository keepBooksDetailRepository;
  @Autowired
  private KeepBooksService keepBooksService;
  @Autowired(required = false)
  private LoginUserService loginUserService;
  @Autowired(required = false)
  private GenerateCodeService generateCodeService;
  @Autowired
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public Page<KeepBooksDetailEntity> findByConditions(Pageable pageable, KeepBooksDetailDto dto) {
    ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    if (dto == null) {
      dto = new KeepBooksDetailDto();
    }
    dto.setTenantCode(TenantUtils.getTenantCode());
    return this.keepBooksDetailRepository.findByConditions(pageable, dto);
  }

  /**
   * 昨日上账
   *
   * @param lastDay
   * @return
   */
  @Override
  public BigDecimal sumByLastDay(String lastDay) {

    Validate.notBlank(lastDay, "时间不能为空");
    BigDecimal keepBooks = keepBooksDetailRepository.sumByLastDay(lastDay);
    if (keepBooks == null) {
      return BigDecimal.ZERO;
    }
    return keepBooks;
  }

  /**
   * 创建
   *
   * @param dto
   * @return
   */
  @Override
  @Transactional
  public KeepBooksDetailEntity create(KeepBooksDetailDto dto) {
    this.validateCreate(dto);
    KeepBooksDto keepBooksDto = this.nebulaToolkitService.copyObjectByWhiteList(dto, KeepBooksDto.class, HashSet.class, ArrayList.class);
    KeepBooksEntity result = this.keepBooksService.create(keepBooksDto);
    KeepBooksDetailEntity create = new KeepBooksDetailEntity();
    create.setTenantCode(TenantUtils.getTenantCode());
    Validate.notNull(this.generateCodeService,"没有编码生成器");
    create.setCode(this.generateCodeService.generateCode(RedPacketCodeConstant.KEEPBOOK_CODE,1).get(0));
    create.setRemark(dto.getRemark());
    create.setAmount(dto.getAmount());
    create.setBalance(result.getBalance());
    create.setCreateAccount(loginUserService.getLoginAccountName());
    create.setCreateTime(new Date());
    create.setKeepBooksId(result.getId());
    this.keepBooksDetailRepository.save(create);
    return create;
  }

  /**
   * 验证
   *
   * @param dto
   */
  private void validateCreate(KeepBooksDetailDto dto) {
    Validate.notNull(dto, "创建时，数据不能为空");
    Validate.notNull(dto.getAmount(), "上账金额不能为空");
    Validate.notBlank(dto.getRemark(), "上账描述不能为空");
  }
}
