package com.biz.crm.cps.business.reward.redpacket.local.service.internal;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.reward.redpacket.local.entity.KeepBooksEntity;
import com.biz.crm.cps.business.reward.redpacket.local.repository.KeepBooksRepository;
import com.biz.crm.cps.business.reward.redpacket.local.service.KeepBooksService;
import com.biz.crm.cps.business.reward.redpacket.sdk.dto.KeepBooksDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @ClassName: KeepBooksServiceImpl
 * @Author: yangfan
 * @Description: 上账记录实现类
 * @Date: 2021/8/7 15:50
 * @Version: 1.0
 */

@Service
public class KeepBooksServiceImpl implements KeepBooksService {

  @Autowired
  private KeepBooksRepository keepBooksRepository;
  @Autowired(required = false)
  private LoginUserService loginUserService;

  @Override
  @Transactional
  public void updateTop1SubBalance(BigDecimal amount) {
    /**
     * 更新上账 账户余额 信息
     * 1.查询最新一个上账信息
     * 2 如果不为空更新账户余额
     */
    KeepBooksEntity booksEntity = this.findByTenantCode(TenantUtils.getTenantCode());
    Validate.notNull(booksEntity, "账户记录不存在!");
    long count = this.keepBooksRepository.subtractBalance(booksEntity.getId(), amount, loginUserService.getLoginAccountName());
    Validate.isTrue(count > 0, "扣减余额失败！");

  }

  /**
   * 创建
   *
   * @param keepBooksDto
   * @return
   */
  @Override
  @Transactional
  public KeepBooksEntity create(KeepBooksDto keepBooksDto) {
    this.validateCreate(keepBooksDto);
    KeepBooksEntity old = this.findByTenantCode(TenantUtils.getTenantCode());
    if (old != null) {
      long count = this.keepBooksRepository.addBalance(old.getId(), keepBooksDto.getAmount(), loginUserService.getLoginAccountName());
      Validate.isTrue(count > 0, "上账失败！");
      BigDecimal balance = this.findBalanceById(old.getId());
      old.setBalance(balance);
      return old;
    } else {
      KeepBooksEntity create = new KeepBooksEntity();
      create.setTenantCode(TenantUtils.getTenantCode());
      create.setRemark(keepBooksDto.getRemark());
      create.setBalance(keepBooksDto.getAmount());
      create.setCreateAccount(loginUserService.getLoginAccountName());
      create.setCreateTime(new Date());
      this.keepBooksRepository.save(create);
      return create;
    }
  }

  @Override
  public KeepBooksEntity findByTenantCode(String tenantCode) {
    if (StringUtils.isBlank(tenantCode)) {
      return null;
    }
    return this.keepBooksRepository.findByTenantCode(tenantCode);
  }

  @Override
  public BigDecimal findBalanceById(String id) {
    if (StringUtils.isBlank(id)) {
      return null;
    }
    return this.keepBooksRepository.findBalanceById(id);
  }

  /**
   * 验证
   *
   * @param keepBooksDto
   */
  private void validateCreate(KeepBooksDto keepBooksDto) {
    Validate.notNull(keepBooksDto, "创建时，数据不能为空");
    Validate.notNull(keepBooksDto.getAmount(), "上账金额不能为空");
    Validate.notBlank(keepBooksDto.getRemark(), "上账描述不能为空");
  }
}
