package com.biz.crm.cps.business.reward.redpacket.local.service.internal;

import com.biz.crm.cps.business.reward.redpacket.local.entity.MaxAmountLimitEntity;
import com.biz.crm.cps.business.reward.redpacket.local.repository.MaxAmountLimitRepository;
import com.biz.crm.cps.business.reward.redpacket.local.service.MaxAmountLimitService;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.Set;

/**
 * 金额限制明细接口实现
 * @Author: zengxingwang
 * @Date: 2021/10/11 18:29
 */
@Service
public class MaxAmountLimitServiceImpl implements MaxAmountLimitService {

  @Autowired
  private MaxAmountLimitRepository maxAmountLimitRepository;

  /**
   * 创建金额限制明细
   * @param amountLimitDetails
   * @param id
   */
  @Override
  @Transactional
  public void create(Set<MaxAmountLimitEntity> amountLimitDetails, String id) {
    Validate.notBlank(id, "创建金额限制明细时，关联id不能为空");
    Validate.isTrue(!CollectionUtils.isEmpty(amountLimitDetails), "创建金额限制明细时，数据不能为空");
    amountLimitDetails.stream().forEach(item -> item.setRedPacketConfigId(id));
    //先删除旧数据
    maxAmountLimitRepository.deleteByRedPacketConfigId(id);

    maxAmountLimitRepository.saveBatch(amountLimitDetails);
  }
}
