package com.biz.crm.cps.business.reward.redpacket.local.service.internal;

import com.biz.crm.cps.business.reward.redpacket.local.entity.MaxCountLimitEntity;
import com.biz.crm.cps.business.reward.redpacket.local.repository.MaxCountLimitRepository;
import com.biz.crm.cps.business.reward.redpacket.local.service.MaxCountLimitService;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.Set;

/**
 * @Author: zengxingwang
 * @Date: 2021/10/11 18:29
 */
@Service
public class MaxCountLimitServiceImpl implements MaxCountLimitService {

  @Autowired
  private MaxCountLimitRepository maxCountLimitRepository;

  /**
   * 创建次数限制明细
   * @param countLimitDetails
   * @param id
   */
  @Override
  @Transactional
  public void create(Set<MaxCountLimitEntity> countLimitDetails, String id) {
    Validate.notBlank(id, "创建次数限制明细，关联id不能为空");
    Validate.isTrue(!CollectionUtils.isEmpty(countLimitDetails), "创建次数限制明细，数据不能为空");
    countLimitDetails.stream().forEach(item -> item.setRedPacketConfigId(id));
    //先删除旧数据
    maxCountLimitRepository.deleteByRedPacketConfigId(id);

    maxCountLimitRepository.saveBatch(countLimitDetails);
  }
}
