package com.biz.crm.cps.business.reward.redpacket.local.service.internal;

import com.biz.crm.cps.business.reward.redpacket.local.repository.RedPacketAgreementRewardStatisticsVoRepository;
import com.biz.crm.cps.business.reward.redpacket.sdk.service.RedPacketAgreementRewardStatisticsVoService;
import com.biz.crm.cps.business.reward.sdk.vo.AgreementRewardStatisticsVo;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

/**
 * @author hecheng
 * @description: 协议统计汇总收益
 * @date 2021/8/27 下午7:47
 */
@Service("RedPacketAgreementRewardStatisticsVoServiceImpl")
public class RedPacketAgreementRewardStatisticsVoServiceImpl implements RedPacketAgreementRewardStatisticsVoService {

  @Autowired
  private RedPacketAgreementRewardStatisticsVoRepository redPacketAgreementRewardStatisticsVoRepository;

  @Override
  public List<AgreementRewardStatisticsVo> findByParticipatorCodeAndTemplateCodes(String participatorCode, List<String> templateCodes) {
    if (StringUtils.isBlank(participatorCode) || CollectionUtils.isEmpty(templateCodes)) {
      return null;
    }
    return this.redPacketAgreementRewardStatisticsVoRepository.findByParticipatorCodeAndTemplateCodes(participatorCode, templateCodes);
  }
}
