package com.biz.crm.cps.business.reward.redpacket.local.service.internal;

import com.biz.crm.cps.business.reward.redpacket.local.entity.KeepBooksEntity;
import com.biz.crm.cps.business.reward.redpacket.local.service.KeepBooksDetailService;
import com.biz.crm.cps.business.reward.redpacket.local.service.KeepBooksService;
import com.biz.crm.cps.business.reward.redpacket.local.service.RedPacketDetailService;
import com.biz.crm.cps.business.reward.redpacket.sdk.service.RedPacketBalanceVoService;
import com.biz.crm.cps.business.reward.redpacket.sdk.service.RedPacketStatisticsDayVoService;
import com.biz.crm.cps.business.reward.redpacket.sdk.vo.RedPacketBalanceVo;
import com.biz.crm.cps.business.reward.redpacket.sdk.vo.RedPacketStatisticsDayVo;

import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

/**
 * @Author: zengxingwang
 * @Date: 2021/8/7 17:23
 */
@Service
public class RedPacketBalanceVoServiceImpl implements RedPacketBalanceVoService {

  @Autowired
  private KeepBooksService keepBooksService;
  @Autowired
  private KeepBooksDetailService keepBooksDetailService;
  @Autowired
  private RedPacketDetailService redPacketDetailService;
  @Autowired
  private RedPacketStatisticsDayVoService redPacketStatisticsDayVoService;

  /**
   * 红包余额看板
   * @param statisticsDay 统计天数
   * @return
   */
  @Override
  public RedPacketBalanceVo findByStatisticsDay(Integer statisticsDay) {
    if(statisticsDay == null){
      return null;
    }
    Date date = new Date();
    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    Calendar c = Calendar.getInstance();
    c.setTime(date);

    // 指定日的开始日期
    c.add(Calendar.DATE, 1 - statisticsDay);
    String startDay =  sdf.format(c.getTime());

    // 昨日
    c.setTime(date);
    c.add(Calendar.DATE, -1);
    String lastDay =  sdf.format(c.getTime());

    // 指定日期天数内的发放
    List<RedPacketStatisticsDayVo> amountList = redPacketStatisticsDayVoService.findByStartDay(startDay);
    RedPacketBalanceVo vo = new RedPacketBalanceVo();

    // 余额
    KeepBooksEntity balance = keepBooksService.findByTenantCode(TenantUtils.getTenantCode());
    vo.setBalance(balance.getBalance());

    // 昨日发放
    BigDecimal yesterdayAmount = redPacketDetailService.sumByLastDay(lastDay);
    vo.setYesterdayAmount(yesterdayAmount);

    // 昨日上账
    BigDecimal keepBooks = keepBooksDetailService.sumByLastDay(lastDay);
    vo.setYesterdayKeepBooks(keepBooks);

    // 日均发放
    BigDecimal amount = BigDecimal.ZERO;
    for (RedPacketStatisticsDayVo value : amountList) {
      amount = amount.add(value.getAmount());
    }
    vo.setAverageAmount(amount.divide(new BigDecimal(statisticsDay), 2, RoundingMode.HALF_UP));

    // 统计天数
    vo.setStatisticsDay(statisticsDay);

    // 预计天数
    BigDecimal averageAmount = (vo.getAverageAmount() == null || vo.getAverageAmount().compareTo( BigDecimal.ZERO) == 0) ? BigDecimal.ONE : vo.getAverageAmount();
    vo.setPredictDay(Integer.parseInt(vo.getBalance().divide(averageAmount, 0, BigDecimal.ROUND_DOWN).toString()));
    vo.setAmountList(amountList);
    return vo;
  }
}
