package com.biz.crm.cps.business.reward.redpacket.local.service.internal;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.reward.redpacket.local.entity.RedPacketConfigEntity;
import com.biz.crm.cps.business.reward.redpacket.local.repository.MaxAmountLimitRepository;
import com.biz.crm.cps.business.reward.redpacket.local.repository.MaxCountLimitRepository;
import com.biz.crm.cps.business.reward.redpacket.local.repository.RedPacketConfigRepository;
import com.biz.crm.cps.business.reward.redpacket.local.service.MaxAmountLimitService;
import com.biz.crm.cps.business.reward.redpacket.local.service.MaxCountLimitService;
import com.biz.crm.cps.business.reward.redpacket.local.service.RedPacketConfigService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.Date;
import java.util.List;

/**
 * 红包权益配置接口实现
 * @Author: zengxingwang
 * @Date: 2021/10/11 15:32
 */
@Service
public class RedPacketConfigServiceImpl implements RedPacketConfigService {

  @Autowired
  private RedPacketConfigRepository redPacketConfigRepository;
  @Autowired
  private MaxAmountLimitService maxAmountLimitService;
  @Autowired
  private MaxCountLimitService maxCountLimitService;
  @Autowired
  private LoginUserService loginUserService;
  @Autowired
  private MaxAmountLimitRepository maxAmountLimitRepository;
  @Autowired
  private MaxCountLimitRepository maxCountLimitRepository;

  /**
   * 创建红包权益配置
   * @param configs
   * @return
   */
  @Override
  @Transactional
  public void create(List<RedPacketConfigEntity> configs) {
    this.validate(configs);
    String loginAccountName = loginUserService.getLoginAccountName();
    Date date = new Date();
    for(RedPacketConfigEntity config : configs){
      if(StringUtils.isBlank(config.getId())){
        config.setTenantCode(TenantUtils.getTenantCode());
        config.setCreateAccount(loginAccountName);
        config.setCreateTime(date);
        config.setModifyAccount(loginAccountName);
        config.setModifyTime(date);
      }else {
        RedPacketConfigEntity old = redPacketConfigRepository.findById(config.getId());
        Validate.notNull(old, "修改时，未找到对应数据，请检查");
        config.setTenantCode(old.getTenantCode());
        config.setCreateTime(old.getCreateTime());
        config.setCreateAccount(old.getCreateAccount());
        config.setModifyAccount(loginAccountName);
        config.setModifyTime(date);
      }
    }
    redPacketConfigRepository.saveOrUpdateBatch(configs);
    for(RedPacketConfigEntity config : configs){
      String configId = config.getId();
      if (config.getIsMaxCountLimit() == 1) {
        maxCountLimitService.create(config.getCountLimitDetails(), configId);
      } else {
        this.maxCountLimitRepository.deleteByRedPacketConfigId(configId);
      }
      if (config.getIsMaxAmountLimit() == 1) {
        maxAmountLimitService.create(config.getAmountLimitDetails(), configId);
      } else {
        this.maxAmountLimitRepository.deleteByRedPacketConfigId(configId);
      }
    }
  }

  /**
   * 数据验证
   * (0.不限制1.限制)
   * @param configs
   */
  private void validate(List<RedPacketConfigEntity> configs) {
    Validate.notEmpty(configs, "创建红包权益配置时，数据不能为空，请检查");
    for(RedPacketConfigEntity config : configs){
      Validate.notNull(config.getIsAmountLimit(), "创建红包权益配置时，红包提现门槛金额限制必须选择，请检查");
      if(config.getIsAmountLimit() == 0){
        Validate.isTrue(config.getAmountLimit() == null, "创建红包权益配置时，红包提现门槛金额选择不限制后不允许填写限制金额，请检查");
      }else {
        Validate.isTrue(config.getAmountLimit() != null, "创建红包权益配置时，红包提现门槛金额选择限制后必须填写限制金额，请检查");
      }

      Validate.notNull(config.getIsOneCountLimit(), "创建红包权益配置时，单次红包提现金额限制必须选择，请检查");
      if(config.getIsOneCountLimit() == 0){
        Validate.isTrue(config.getOneAmountLimit() == null, "创建红包权益配置时，单次红包提现金额选择不限制后不允许填写限制金额，请检查");
      }else {
        Validate.isTrue(config.getOneAmountLimit() != null, "创建红包权益配置时，单次红包提现金额选择限制后必须填写限制金额，请检查");
      }

      Validate.notNull(config.getIsMaxAmountLimit(), "创建红包权益配置时，红包提现金额上限限制必须选择，请检查");
      if(config.getIsMaxAmountLimit() == 0){
        Validate.isTrue(CollectionUtils.isEmpty(config.getAmountLimitDetails()), "创建红包权益配置时，红包提现金额上限设置选择不限制后不允许填写限制明细，请检查");
      }else {
        Validate.isTrue(!CollectionUtils.isEmpty(config.getAmountLimitDetails()), "创建红包权益配置时，红包提现金额上限设置选择限制后必须填写限制明细，请检查");
      }

      Validate.notNull(config.getIsMaxAmountLimit(), "创建红包权益配置时，红包提现次数上限限制必须选择，请检查");
      if(config.getIsMaxCountLimit() == 0){
        Validate.isTrue(CollectionUtils.isEmpty(config.getCountLimitDetails()), "创建红包权益配置时，红包提现次数上限设置选择不限制后不允许填写限制明细，请检查");
      }else {
        Validate.isTrue(!CollectionUtils.isEmpty(config.getCountLimitDetails()), "创建红包权益配置时，红包提现次数上限设置选择限制后必须填写限制明细，请检查");
      }
    }
  }

  /**
   * 查询所有配置
   * @return
   */
  @Override
  public List<RedPacketConfigEntity> findAll() {
    return redPacketConfigRepository.findAll();
  }
}
