package com.biz.crm.cps.business.reward.redpacket.local.service.internal;

import com.biz.crm.cps.business.reward.redpacket.local.repository.RedPacketStatisticsDayVoRepository;
import com.biz.crm.cps.business.reward.redpacket.sdk.service.RedPacketStatisticsDayVoService;
import com.biz.crm.cps.business.reward.redpacket.sdk.vo.RedPacketStatisticsDayVo;
import com.google.common.collect.Lists;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @Author: zengxingwang
 * @Date: 2021/8/9 18:46
 */
@Service
public class RedPacketStatisticsDayVoServiceImpl implements RedPacketStatisticsDayVoService {

  @Autowired
  private RedPacketStatisticsDayVoRepository redPacketStatisticsDayVoRepository;

  /**
   * 指定日期天数内的发放
   *
   * @param startDay
   * @return
   */
  @Override
  public List<RedPacketStatisticsDayVo> findByStartDay(String startDay) {
    if (StringUtils.isBlank(startDay)) {
      return Lists.newArrayList();
    }
    List<RedPacketStatisticsDayVo> list = redPacketStatisticsDayVoRepository.findByStartDay(startDay);
    if (CollectionUtils.isEmpty(list)) {
      return Lists.newArrayList();
    }
    return list;
  }
}
