package com.biz.crm.cps.business.reward.redpacket.local.service.internal;

import com.biz.crm.cps.business.reward.redpacket.local.repository.RedPacketTriggerObjectStatisticsVoRepository;
import com.biz.crm.cps.business.reward.redpacket.sdk.service.RedPacketTriggerObjectStatisticsVoService;
import com.biz.crm.cps.business.reward.sdk.vo.TriggerObjectRewardStatisticsVo;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

/**
 * @author hecheng
 * @description: 触发对象 获利统计实现
 * @date 2021/9/2 下午6:47
 */
@Service("RedPacketTriggerObjectStatisticsVoServiceImpl")
public class RedPacketTriggerObjectStatisticsVoServiceImpl implements RedPacketTriggerObjectStatisticsVoService {
  @Autowired
  private RedPacketTriggerObjectStatisticsVoRepository triggerObjectStatisticsVoRepository;

  @Override
  public List<TriggerObjectRewardStatisticsVo> findByTriggerActionAndTriggerObjects(String triggerAction, List<String> triggerObjects) {
    if (StringUtils.isBlank(triggerAction) || CollectionUtils.isEmpty(triggerObjects)) {
      return null;
    }
    return this.triggerObjectStatisticsVoRepository.findByTriggerActionAndTriggerObjects(triggerAction, triggerObjects);
  }
}
