package com.biz.crm.cps.business.reward.redpacket.local.service.observer;

import com.biz.crm.cps.business.reward.redpacket.sdk.service.RedPacketAgreementRewardStatisticsVoService;
import com.biz.crm.cps.business.reward.sdk.service.observer.RewardMountRegister;
import com.biz.crm.cps.business.reward.sdk.service.observer.RewardRelAgreementServiceObserver;
import com.biz.crm.cps.business.reward.sdk.vo.AgreementRewardStatisticsVo;
import com.biz.crm.cps.business.reward.sdk.vo.RewardRelAgreementItemVo;
import com.biz.crm.cps.business.reward.sdk.vo.RewardTypeStatisticsVo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

/**
 * @author hecheng
 * @description: 统计协议获利汇总观察者接口实现
 * @date 2021/8/24 下午7:23
 */
@Component("RedPacketRewardRelAgreementServiceObserverImpl")
public class RedPacketRewardRelAgreementServiceObserverImpl implements RewardRelAgreementServiceObserver {

  @Autowired
  @Qualifier("RedpacketRewardMountRegisterServiceImpl")
  private RewardMountRegister rewardMountRegister;
  @Autowired
  private RedPacketAgreementRewardStatisticsVoService redPacketAgreementRewardStatisticsVoService;


  @Override
  public List<RewardRelAgreementItemVo> onRequestRewardRelAgreementItems(String participatorCode, List<String> templateCodes) {
    if (StringUtils.isBlank(participatorCode) || CollectionUtils.isEmpty(templateCodes)) {
      return null;
    }
    List<AgreementRewardStatisticsVo> result = this.redPacketAgreementRewardStatisticsVoService.findByParticipatorCodeAndTemplateCodes(participatorCode, templateCodes);
    if(CollectionUtils.isEmpty(result)){
      result = Lists.newArrayList();
    }
    List<RewardRelAgreementItemVo> list = Lists.newArrayList();
    for (String templateCode : templateCodes) {
      RewardTypeStatisticsVo vo = new RewardTypeStatisticsVo();
      AgreementRewardStatisticsVo statisticsVo = result.stream().filter(item -> Objects.equals(templateCode, item.getTemplateCode())).findFirst().orElse(null);
      vo.setName(this.rewardMountRegister.getName());
      vo.setFlag(this.rewardMountRegister.getFlag());
      vo.setKey(this.rewardMountRegister.getKey());
      BigDecimal amount = statisticsVo == null ? BigDecimal.ZERO : statisticsVo.getAmount();
      vo.setAmount(amount.setScale(2, RoundingMode.HALF_UP));
      RewardRelAgreementItemVo item = new RewardRelAgreementItemVo();
      item.setTemplateCode(templateCode);
      item.setRewardStatisticsVo(vo);
      list.add(item);
    }
    return list;
  }
}
