package com.biz.crm.cps.business.reward.redpacket.local.service.observer;

import com.biz.crm.cps.business.reward.redpacket.sdk.service.RedPacketParticipatorRewardStatisticsVoService;
import com.biz.crm.cps.business.reward.sdk.service.observer.RewardMountRegister;
import com.biz.crm.cps.business.reward.sdk.service.observer.RewardRelParticipatorServiceObserver;
import com.biz.crm.cps.business.reward.sdk.vo.ParticipatorRewardStatisticsVo;
import com.biz.crm.cps.business.reward.sdk.vo.RewardRelParticipatorItemVo;
import com.biz.crm.cps.business.reward.sdk.vo.RewardTypeStatisticsVo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

/**
 * @author hecheng
 * @description: 统计协议获利汇总观察者接口实现
 * @date 2021/8/24 下午7:23
 */
@Component("RedPacketRewardRelParticipatorServiceObserverImpl")
public class RedPacketRewardRelParticipatorServiceObserverImpl
    implements RewardRelParticipatorServiceObserver {

  @Autowired
  @Qualifier("RedpacketRewardMountRegisterServiceImpl")
  private RewardMountRegister rewardMountRegister;

  @Autowired
  private RedPacketParticipatorRewardStatisticsVoService
      redPacketParticipatorRewardStatisticsVoService;

  @Override
  public List<RewardRelParticipatorItemVo> onRequestRewardRelParticipatorItems(
      List<String> participatorCodes) {
    if (CollectionUtils.isEmpty(participatorCodes)) {
      return null;
    }
    List<ParticipatorRewardStatisticsVo> result =
        this.redPacketParticipatorRewardStatisticsVoService.findByParticipatorCodes(
            participatorCodes);
    if (CollectionUtils.isEmpty(result)) {
      result = Lists.newArrayList();
    }
    List<RewardRelParticipatorItemVo> list = Lists.newArrayList();
    for (String participatorCode : participatorCodes) {
      RewardTypeStatisticsVo vo = new RewardTypeStatisticsVo();
      ParticipatorRewardStatisticsVo statisticsVo =
          result.stream()
              .filter(item -> Objects.equals(participatorCode, item.getParticipatorCode()))
              .findFirst()
              .orElse(null);
      vo.setName(this.rewardMountRegister.getName());
      vo.setFlag(this.rewardMountRegister.getFlag());
      vo.setKey(this.rewardMountRegister.getKey());
      BigDecimal amount = statisticsVo == null ? BigDecimal.ZERO : statisticsVo.getAmount();
      BigDecimal balance = statisticsVo == null ? BigDecimal.ZERO : statisticsVo.getBalance();

      vo.setAmount(amount.setScale(2, RoundingMode.HALF_UP));
      vo.setBalance(balance.setScale(2, RoundingMode.HALF_UP));
      vo.setTodayAmount(BigDecimal.ZERO);
      if(Objects.nonNull(statisticsVo)){
        vo.setTodayAmount(
            Optional.ofNullable(statisticsVo.getTodayAmount())
                .orElse(BigDecimal.ZERO)
                .setScale(2, RoundingMode.HALF_UP));
      }
      RewardRelParticipatorItemVo item = new RewardRelParticipatorItemVo();
      item.setParticipatorCode(participatorCode);
      item.setRewardStatisticsVo(vo);
      list.add(item);
    }
    return list;
  }
}
